/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraEvent;

public class ImageReadoutParametersEvent
extends CameraEvent {
    private final String imageName;
    private final String ccdLocation;
    private final String raftBay;
    private final String ccdSlot;
    private final CcdType[] ccdType;
    private final int[] overRows;
    private final int[] overCols;
    private final int[] readRows;
    private final int[] readCols;
    private final int[] readCols2;
    private final int[] preCols;
    private final int[] preRows;
    private final int[] postCols;
    private final int[] underCols;
    private final String daqFolder;
    private final String daqAnnotation;

    public ImageReadoutParametersEvent(String imageName, String ccdLocation, String raftBay, String ccdSlot, CcdType[] ccdType, int[] overRows, int[] overCols, int[] readRows, int[] readCols, int[] readCols2, int[] preCols, int[] preRows, int[] postCols, int[] underCols, String daqFolder, String daqAnnotation) {
        this.imageName = imageName;
        this.ccdLocation = ccdLocation;
        this.raftBay = raftBay;
        this.ccdSlot = ccdSlot;
        this.ccdType = ccdType;
        this.overRows = overRows;
        this.overCols = overCols;
        this.readRows = readRows;
        this.readCols = readCols;
        this.readCols2 = readCols2;
        this.preCols = preCols;
        this.preRows = preRows;
        this.postCols = postCols;
        this.underCols = underCols;
        this.daqFolder = daqFolder;
        this.daqAnnotation = daqAnnotation;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getCcdLocation() {
        return this.ccdLocation;
    }

    public String getRaftBay() {
        return this.raftBay;
    }

    public String getCcdSlot() {
        return this.ccdSlot;
    }

    public CcdType[] getCcdType() {
        return this.ccdType;
    }

    public int[] getOverRows() {
        return this.overRows;
    }

    public int[] getOverCols() {
        return this.overCols;
    }

    public int[] getReadRows() {
        return this.readRows;
    }

    public int[] getReadCols() {
        return this.readCols;
    }

    public int[] getReadCols2() {
        return this.readCols2;
    }

    public int[] getPreCols() {
        return this.preCols;
    }

    public int[] getPreRows() {
        return this.preRows;
    }

    public int[] getPostCols() {
        return this.postCols;
    }

    public int[] getUnderCols() {
        return this.underCols;
    }

    public String getDaqFolder() {
        return this.daqFolder;
    }

    public String getDaqAnnotation() {
        return this.daqAnnotation;
    }

    public String toString() {
        return "ImageReadoutParametersEvent{imageName=" + this.imageName + ", ccdLocation=" + this.ccdLocation + ", raftBay=" + this.raftBay + ", ccdSlot=" + this.ccdSlot + ", ccdType=" + Arrays.toString((Object[])this.ccdType) + ", overRows=" + Arrays.toString(this.overRows) + ", overCols=" + Arrays.toString(this.overCols) + ", readRows=" + Arrays.toString(this.readRows) + ", readCols=" + Arrays.toString(this.readCols) + ", readCols2=" + Arrays.toString(this.readCols2) + ", preCols=" + Arrays.toString(this.preCols) + ", preRows=" + Arrays.toString(this.preRows) + ", postCols=" + Arrays.toString(this.postCols) + ", underCols=" + Arrays.toString(this.underCols) + ", daqFolder=" + this.daqFolder + ", daqAnnotation=" + this.daqAnnotation + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String imageName;
        private String ccdLocation;
        private String raftBay;
        private String ccdSlot;
        private CcdType[] ccdType;
        private int[] overRows;
        private int[] overCols;
        private int[] readRows;
        private int[] readCols;
        private int[] readCols2;
        private int[] preCols;
        private int[] preRows;
        private int[] postCols;
        private int[] underCols;
        private String daqFolder;
        private String daqAnnotation;

        private Builder() {
        }

        public Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public Builder ccdLocation(String ccdLocation) {
            this.ccdLocation = ccdLocation;
            return this;
        }

        public Builder raftBay(String raftBay) {
            this.raftBay = raftBay;
            return this;
        }

        public Builder ccdSlot(String ccdSlot) {
            this.ccdSlot = ccdSlot;
            return this;
        }

        public Builder ccdType(CcdType[] ccdType) {
            this.ccdType = ccdType;
            return this;
        }

        public Builder overRows(int[] overRows) {
            this.overRows = overRows;
            return this;
        }

        public Builder overCols(int[] overCols) {
            this.overCols = overCols;
            return this;
        }

        public Builder readRows(int[] readRows) {
            this.readRows = readRows;
            return this;
        }

        public Builder readCols(int[] readCols) {
            this.readCols = readCols;
            return this;
        }

        public Builder readCols2(int[] readCols2) {
            this.readCols2 = readCols2;
            return this;
        }

        public Builder preCols(int[] preCols) {
            this.preCols = preCols;
            return this;
        }

        public Builder preRows(int[] preRows) {
            this.preRows = preRows;
            return this;
        }

        public Builder postCols(int[] postCols) {
            this.postCols = postCols;
            return this;
        }

        public Builder underCols(int[] underCols) {
            this.underCols = underCols;
            return this;
        }

        public Builder daqFolder(String daqFolder) {
            this.daqFolder = daqFolder;
            return this;
        }

        public Builder daqAnnotation(String daqAnnotation) {
            this.daqAnnotation = daqAnnotation;
            return this;
        }

        public ImageReadoutParametersEvent build() {
            return new ImageReadoutParametersEvent(this.imageName, this.ccdLocation, this.raftBay, this.ccdSlot, this.ccdType, this.overRows, this.overCols, this.readRows, this.readCols, this.readCols2, this.preCols, this.preRows, this.postCols, this.underCols, this.daqFolder, this.daqAnnotation);
        }
    }

    public static enum CcdType implements SALEnum
    {
        E2V,
        ITL;

    }
}

