/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.pfeiffer.ASM380;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.data.VacSysState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ASM380Device
extends Device {
    boolean TEST_MODE = false;
    public static final int PUMP_STOPPED = 0;
    public static final int PUMP_PUMPING = 1;
    public static final int VENT_CLOSED = 0;
    public static final int VENT_VENTING = 1;
    CCSTimeStamp lastChannelUpdateStamp;
    PumpSwitchState pumpSwitchState = new PumpSwitchState(false, CCSTimeStamp.currentTime());
    VentSwitchState ventSwitchState = new VentSwitchState(false, CCSTimeStamp.currentTime());
    private double cryoForelinePressure = -1.0;
    private CCSTimeStamp cryoForelineTimeStamp = null;
    private double hxForelinePressure = -1.0;
    private CCSTimeStamp hxForelineTimeStamp = null;
    private double lastInletPressure = Double.NaN;
    private String targetPressureSrc = null;
    private VacSysState vs;
    private List<MonitorUpdateTask> tasksForDevice = null;
    @ConfigurationParameter(name="devcId", category="Cryo", isFinal=true, units="unitless", description="The device id")
    private volatile String devcId;
    @ConfigurationParameter(category="Cryo", isFinal=false, range="0.00..800.0", units="Torr", description="Maximum pressure while venting")
    private volatile double maxVentPressure = 765.0;
    @ConfigurationParameter(category="Cryo", isFinal=false, range="-1.00..800.0", units="Torr", description="Minimum pressure while venting")
    private volatile double minPumpPressure = 0.001;
    private boolean abortVent = false;
    private boolean abortPump = false;
    private final DriverConstants.ConnType connType = DriverConstants.ConnType.SERIAL;
    private final int baudRate = 9600;
    private static final Logger LOG = Logger.getLogger(ASM380Device.class.getName());
    private final ASM380 asm380Dev = new ASM380();
    private int errorCount = 0;
    private boolean initError = false;
    private final Map<String, Boolean> activeAlerts = new HashMap<String, Boolean>();
    private boolean pulseVentingActive = false;
    private String lastVentStatus = null;
    private String reportedPumpStatus = null;
    private boolean lastPumpStatus = false;
    private boolean pumpTransActive = false;
    private int lastStatus;

    public void initDevice() {
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"devcId", (String)"is missing");
        }
        this.fullName = "ASM380";
        this.tasksForDevice = this.getDeviceMonitorUpdateTasks();
    }

    public void initialize() {
        block7: {
            try {
                this.asm380Dev.open(this.connType, this.devcId, 9600, 0);
                this.errorCount = 0;
                LOG.log(Level.INFO, "Connected to {0}", new Object[]{this.fullName});
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (!this.initError) {
                    LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                    this.initError = true;
                }
                try {
                    this.asm380Dev.close();
                }
                catch (DriverException driverException) {
                    // empty catch block
                }
                if (!this.TEST_MODE) break block7;
                this.setOnline(true);
            }
        }
        try {
            int status = this.asm380Dev.getStatus();
            this.pumpSwitchState.state = (status & 4) != 0;
            this.pumpSwitchState.time = CCSTimeStamp.currentTime();
            this.lastPumpStatus = this.pumpSwitchState.state;
            this.reportedPumpStatus = this.lastPumpStatus ? "on" : "off";
            this.lastStatus = status;
            this.ventSwitchState.state = (status & 0x200) != 0;
            this.ventSwitchState.time = CCSTimeStamp.currentTime();
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "Setting {0} offline due to error retrieving initial status {0}: {1}", new Object[]{this.fullName, ex});
            this.setOnline(false);
        }
    }

    public void close() {
        try {
            this.asm380Dev.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    public double readChannel(Channel ch) {
        double value = Double.NaN;
        if (this.isOnline() && !this.TEST_MODE) {
            switch (ch.getHwChan()) {
                case 0: {
                    try {
                        this.lastInletPressure = value = this.readInletPressure();
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading pressure from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 1: {
                    try {
                        String tmpValue = this.getPumpStatus();
                        if (tmpValue.equals("on")) {
                            value = 1.0;
                            break;
                        }
                        if (tmpValue.equals("off")) {
                            value = 0.0;
                            break;
                        }
                        LOG.log(Level.WARNING, String.format("getPumpStatus() returned: %s, skipping", tmpValue));
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading pump cycle enabled status from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 2: {
                    try {
                        value = this.asm380Dev.readTemperature();
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading temperature from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 4: {
                    try {
                        value = this.getVentValveStatus().contains("open") ? 1.0 : 0.0;
                        this.errorCount = 0;
                    }
                    catch (DriverException e) {
                        LOG.log(Level.SEVERE, "Error reading venting status from {0}: {1}", new Object[]{this.fullName, e});
                        if (++this.errorCount < 5) break;
                        this.setOnline(false);
                    }
                    break;
                }
                case 5: {
                    value = this.lastInletPressure;
                }
            }
        }
        return value;
    }

    @Command(description="Show the version string")
    public String showVersion() throws DriverException {
        return this.asm380Dev.getVersion();
    }

    @Command(description="Show the instrument status")
    public String showStatus() throws DriverException {
        return String.format("0x%04x", this.asm380Dev.getStatus());
    }

    @Command(description="Show the decoded instrument status")
    public String showDecodedStatus() throws DriverException {
        String[] status = this.asm380Dev.decodeStatus();
        StringBuilder text = new StringBuilder();
        for (int j = 0; j < status.length; ++j) {
            if (j != 0) {
                text.append("\n");
            }
            text.append(status[j]);
        }
        return text.toString();
    }

    @Command(description="Return the reference pressure")
    public double getReferencePressure() throws DriverException {
        double pressure = -1.0;
        if (this.isOnline()) {
            if (this.vs != null && !this.TEST_MODE) {
                LOG.fine("HXForelineValveStatus = " + this.vs.getHXForelineValveStatus());
                if (this.vs.getHXForelineValveStatus().contains("OPEN") && !this.vs.getCryoForelineValveStatus().contains("OPEN")) {
                    pressure = this.vs.getHXFlinePress();
                    this.targetPressureSrc = "HX";
                    LOG.fine("Using HX foreline pressure as the reference.");
                } else if (this.vs.getCryoForelineValveStatus().contains("OPEN") && !this.vs.getHXForelineValveStatus().contains("OPEN")) {
                    pressure = this.vs.getCryoFlinePress();
                    this.targetPressureSrc = "Cryo";
                    LOG.fine("Using Cryo foreline pressure as the reference.");
                } else if (this.vs.getHXForelineValveStatus().contains("OPEN") && this.vs.getCryoForelineValveStatus().contains("OPEN")) {
                    pressure = (this.vs.getHXFlinePress() + this.vs.getCryoFlinePress()) / 2.0;
                    this.targetPressureSrc = "HX and Cryo";
                    LOG.fine("Using the average of the cryo and foreline pressures as the reference.");
                } else {
                    pressure = this.readInletPressure();
                    this.targetPressureSrc = "Inlet";
                    LOG.fine("Using inlet pressure because both foreline valves are closed.");
                }
            } else {
                pressure = this.readInletPressure();
                this.targetPressureSrc = "Inlet";
                LOG.fine("Using inlet pressure because there is no VacSysState or Pump Cart not online.");
            }
        }
        return pressure;
    }

    @Command(description="Read the inlet pressure")
    public double readInletPressure() throws DriverException {
        return this.TEST_MODE ? -1.0 : this.asm380Dev.readInletPressure();
    }

    @Command(description="Read the temperature")
    public int readTemperature() throws DriverException {
        return this.asm380Dev.readTemperature();
    }

    @Command(description="Show the primary pump operating hours")
    public int showPrimaryHours() throws DriverException {
        return this.asm380Dev.getPrimaryHours();
    }

    @Command(description="Show the high vacuum pump operating hours")
    public int showHighVacHours() throws DriverException {
        return this.asm380Dev.getHighVacHours();
    }

    @Command(description="Show target pressure src")
    public String getTargetPressureSrc() {
        try {
            if (this.isOnline()) {
                double d = this.getReferencePressure();
            }
        }
        catch (DriverException ex) {
            LOG.log(Level.INFO, "Exception while getting reference pressure: " + (Object)((Object)ex));
        }
        return this.targetPressureSrc;
    }

    @Command(description="Show the stored warning codes")
    public String showWarningCodes() throws DriverException {
        return ASM380Device.showCodes(this.asm380Dev.getWarningCodes());
    }

    @Command(description="Show the stored fault codes")
    public String showFaultCodes() throws DriverException {
        return ASM380Device.showCodes(this.asm380Dev.getFaultCodes());
    }

    private static String showCodes(int[] codes) {
        if (codes.length == 0) {
            return "No codes stored";
        }
        StringBuilder text = new StringBuilder();
        for (int code : codes) {
            text.append(code).append(" ");
        }
        return text.toString();
    }

    @Command(description="Clear the stored warning codes")
    public void clearWarnings() throws DriverException {
        this.asm380Dev.clearWarnings();
    }

    @Command(description="Clear the stored fault codes")
    public void clearFaults() throws DriverException {
        this.asm380Dev.clearFaults();
    }

    @Command(description="set pump on (true) or off (false)")
    public void pumpOn(boolean on) throws DriverException {
        if (!this.getVentValveStatus().contains("closed") && on) {
            LOG.log(Level.SEVERE, "Rejected attempt to turn pumping on with the valve not in the closed state.");
        } else {
            this.asm380Dev.pumpOn(on);
            this.pumpSwitchState.time = CCSTimeStamp.currentTime();
            int maxcount = 10;
            Object pStatus = null;
            for (int count = 0; count < maxcount; ++count) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.SEVERE, "sleep interrupted while waiting for pumping state change {0}");
                }
                if (!this.getPumpStatus().equals(on ? "on" : "off")) continue;
                this.pumpSwitchState.state = on;
                LOG.log(Level.INFO, "Pump is {0} by command", this.lastPumpStatus ? "on" : "off");
                this.forceDataPublication();
                return;
            }
            this.asm380Dev.pumpOn(false);
            LOG.log(Level.SEVERE, "pumpOn({0}) failed with timeout, forcing off", on);
            this.forceDataPublication();
        }
    }

    @Command(description="get the pumping status")
    public String getPumpStatus() throws DriverException {
        boolean pumpStatus;
        int status = this.asm380Dev.getStatus();
        boolean bl = pumpStatus = (status & 4) != 0;
        if (pumpStatus == this.lastPumpStatus) {
            this.reportedPumpStatus = pumpStatus ? "on" : "off";
            this.pumpTransActive = false;
        } else {
            LOG.log(Level.INFO, String.format("pumpStatus changed: %s -> %s", this.lastPumpStatus, pumpStatus));
            LOG.log(Level.INFO, String.format("pumpStatus detailed: 0x%04x -> 0x%04x", this.lastStatus, status));
            if (!this.pumpTransActive) {
                this.reportedPumpStatus = "TransStarted";
                this.pumpTransActive = true;
            } else {
                this.reportedPumpStatus = pumpStatus ? "on" : "off";
                this.pumpTransActive = false;
                LOG.log(Level.WARNING, String.format("Glitch detected in pump status, ignoring", this.lastStatus, status));
            }
        }
        this.lastPumpStatus = pumpStatus;
        this.lastStatus = status;
        return this.reportedPumpStatus;
    }

    @Command(description="get the pumping switch state")
    public boolean getPumpSwitchState() {
        return this.pumpSwitchState.state;
    }

    @Command(description="get the pumping switch state update time")
    public CCSTimeStamp getPumpSwitchStateTime() {
        return this.pumpSwitchState.time;
    }

    @Command(description="get the pumping switch state")
    public boolean getVentSwitchState() {
        return this.ventSwitchState.state;
    }

    @Command(description="get the pumping switch state update time")
    public CCSTimeStamp getVentSwitchStateTime() {
        return this.ventSwitchState.time;
    }

    @Command(description="execute open vent sequence")
    public void openVentValve(boolean open) throws DriverException {
        if (!this.getPumpStatus().equals("off") && open) {
            LOG.log(Level.SEVERE, "Rejected attempt to open vent while pump not in off state.");
        } else {
            if (open) {
                this.abortVent = false;
            }
            if (!this.TEST_MODE) {
                this.asm380Dev.setVentValveNominal();
                this.asm380Dev.openVentValve(open);
            }
            this.ventSwitchState.state = open;
            this.ventSwitchState.time = CCSTimeStamp.currentTime();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "Interrupted!! Prematurely interrupted while waiting for venting state change " + ex);
            }
            this.forceDataPublication();
            LOG.log(Level.INFO, "VentStatusAfterSleep: {0}", this.lastVentStatus);
        }
    }

    @Command(description="get the venting status")
    public String getVentValveStatus() throws DriverException {
        this.lastVentStatus = this.TEST_MODE ? "closed" : this.asm380Dev.getVentValveStatus();
        return this.lastVentStatus;
    }

    @Command(description="get the venting valve actuation parameters")
    public String getVentValveParms() throws DriverException {
        return this.asm380Dev.getVentValveParms();
    }

    @Command(description="setup venting sequence")
    public void setVentValveParms(@Argument(description="delay before actuation (0->2 secs)") int delay, @Argument(description="time (secs) in open state") int period) throws DriverException {
        this.asm380Dev.setVentValveParms(delay, period);
    }

    @Command(description="execute pulse vent sequence")
    public void pulseVentValve(final @Argument(description="time (secs) in open state") int seconds) throws DriverException {
        if (this.pulseVentingActive) {
            LOG.log(Level.SEVERE, "Pulse venting already active");
            return;
        }
        Thread vThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (seconds > 0) {
                        ASM380Device.this.asm380Dev.setVentValveParms(0, seconds);
                    }
                    long ventStart = System.currentTimeMillis();
                    ASM380Device.this.openVentValve(true);
                    try {
                        double last_press = 0.0;
                        while (!((System.currentTimeMillis() - ventStart) / 1000L >= (long)(seconds + 1) && seconds >= 0 || ASM380Device.this.abortVent)) {
                            double press = ASM380Device.this.getReferencePressure();
                            if (!(press >= 750.0 && last_press < ASM380Device.this.maxVentPressure || press < ASM380Device.this.maxVentPressure)) {
                                LOG.log(Level.SEVERE, "Interrupted!! current inlet pressure " + press + "Torr exceeds max setting = " + ASM380Device.this.maxVentPressure);
                                break;
                            }
                            Thread.sleep(50L);
                            last_press = press;
                        }
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.SEVERE, "Interrupted!! Prematurely stopping the venting" + ex);
                    }
                }
                catch (DriverException ex) {
                    LOG.log(Level.SEVERE, "Exception while pulse venting: " + (Object)((Object)ex));
                }
                try {
                    ASM380Device.this.openVentValve(false);
                    ASM380Device.this.pulseVentingActive = false;
                }
                catch (DriverException ex) {
                    LOG.log(Level.SEVERE, "Exception while trying to close valve after pulse venting: " + (Object)((Object)ex));
                }
                ASM380Device.this.forceDataPublication();
            }
        });
        vThread.start();
    }

    @Command(description="execute pulse cycling/pumping")
    public void pulsePump(final @Argument(description="time (secs) in pumping state") int seconds) throws DriverException {
        if (this.pumpSwitchState.state) {
            LOG.log(Level.SEVERE, "Pulse pumping already active");
            return;
        }
        try {
            this.pumpOn(true);
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "Exception while pulse pumping: " + (Object)((Object)ex));
            return;
        }
        if (seconds < 0 && this.minPumpPressure <= 0.0) {
            return;
        }
        final long pumpStart = (long)(1000.0 * this.pumpSwitchState.time.getUTCDouble());
        Thread pThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: while (true) {
                    try {
                        while (!(seconds >= 0 && (System.currentTimeMillis() - pumpStart) / 1000L >= (long)seconds || ASM380Device.this.abortPump)) {
                            double press = ASM380Device.this.getReferencePressure();
                            if (press < ASM380Device.this.minPumpPressure) {
                                LOG.log(Level.INFO, "pumping stopped by crossing min pressure:{0}", ASM380Device.this.minPumpPressure);
                                break block6;
                            }
                            try {
                                Thread.sleep(50L);
                                continue block6;
                            }
                            catch (InterruptedException ex) {
                                LOG.log(Level.SEVERE, "sleep interrupted in pulse pumping");
                            }
                        }
                        break;
                    }
                    catch (DriverException ex) {
                        LOG.log(Level.SEVERE, "Exception in pulse pumping" + (Object)((Object)ex));
                        break;
                    }
                }
                try {
                    ASM380Device.this.pumpOn(false);
                }
                catch (DriverException ex) {
                    LOG.log(Level.SEVERE, "Exception while trying to stop pulse pumping: " + (Object)((Object)ex));
                }
            }
        });
        pThread.start();
    }

    @Command(description="set the maximum inlet pressure to vent to")
    public void setMaxVentPressure(double value) throws DriverException {
        this.maxVentPressure = value;
    }

    @Command(type=Command.CommandType.QUERY, description="get the maximum inlet pressure to vent to")
    public double getMaxVentPressure() throws DriverException {
        return this.maxVentPressure;
    }

    @Command(description="set the minimum inlet pressure to pump down to")
    public void setMinPumpPressure(double value) throws DriverException {
        this.minPumpPressure = value;
    }

    @Command(type=Command.CommandType.QUERY, description="get the maximum inlet pressure to vent to")
    public double getMinPumpPressure() throws DriverException {
        return this.minPumpPressure;
    }

    @Command(description="enable/disable pump cart audible alarm")
    public void enableAudibleAlarm(boolean enable) throws DriverException {
        this.asm380Dev.enableAlarm(enable);
    }

    @Command(description="enable/disable pump cart triode filament")
    public void enableFilament(boolean enable) throws DriverException {
        this.asm380Dev.enableFilament(enable);
    }

    @Command(description="reset pump cart triode safety")
    public void resetTriodeSafety() throws DriverException {
        this.asm380Dev.resetTriodeSafety();
    }

    @Command(description="set venting sequence nominal")
    public void setVentValveNominal() throws DriverException {
        this.asm380Dev.setVentValveNominal();
    }

    @Command(description="Write a command")
    public String writeCommand(@Argument(description="The commmand to send") String command) throws DriverException {
        return this.asm380Dev.writeCommand(command);
    }

    @Command(description="set abort flag")
    public void abort() throws DriverException {
        this.abortVent = true;
        this.abortPump = true;
    }

    @Command(description="set abort venting flag and close vent valve")
    public void abortVent() throws DriverException {
        this.abortVent = true;
        this.asm380Dev.setVentValveNominal();
        this.openVentValve(false);
    }

    @Command(description="set abort pumping flag and stop pumping")
    public void abortPump() throws DriverException {
        this.abortPump = true;
        this.pumpOn(false);
    }

    @Command(description="show abort flag")
    public boolean showAbort() throws DriverException {
        return this.abortVent || this.abortPump;
    }

    @Command(description="show venting abort flag")
    public boolean showVentAbortState() throws DriverException {
        return this.abortVent;
    }

    @Command(description="show pumping abort flag")
    public boolean showPumpAbortState() throws DriverException {
        return this.abortPump;
    }

    @Command(description="clear abort flag")
    public void clearAbort() throws DriverException {
        this.abortVent = false;
        this.abortPump = false;
    }

    private void raiseAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active != Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.ALARM, cause);
            this.activeAlerts.put(alert.getAlertId(), true);
        }
    }

    private void lowerAlarm(Alert alert, String cause) {
        Boolean active = this.activeAlerts.get(alert.getAlertId());
        if (active == Boolean.TRUE) {
            this.alertService.raiseAlert(alert, AlertState.NOMINAL, cause);
            this.activeAlerts.put(alert.getAlertId(), false);
        }
    }

    public DeviceState getDeviceState() {
        if (!this.isOnline()) {
            return DeviceState.OFFLINE;
        }
        if (this.reportedPumpStatus.contains("on")) {
            return DeviceState.NORMAL;
        }
        if (this.reportedPumpStatus.contains("off")) {
            return DeviceState.STOPPED;
        }
        return DeviceState.TRANSIT;
    }

    private void forceDataPublication() {
        for (MonitorUpdateTask task : this.tasksForDevice) {
            task.scheduleUpdateAndPublishNow();
        }
    }

    public void updateVacSysState(VacSysState vs) {
        LOG.fine("setting VacSysState in ASM380");
        this.vs = vs;
    }

    static class VentSwitchState {
        boolean state;
        CCSTimeStamp time;

        private VentSwitchState(boolean state, CCSTimeStamp time) {
            this.state = state;
            this.time = time;
        }
    }

    static class PumpSwitchState {
        boolean state;
        CCSTimeStamp time;

        private PumpSwitchState(boolean state, CCSTimeStamp time) {
            this.state = state;
            this.time = time;
        }
    }
}

