/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.function.Supplier;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;

public final class NormalModeService
implements AgentService,
ServiceLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private NormalModeCommands commands;

    @Override
    public String getAgentServiceName() {
        return "normalModeService";
    }

    @Override
    public boolean startForAgent(AgentInfo agentInfo) {
        return agentInfo.isAgentWorkerOrService();
    }

    @Override
    public void preInit() {
        this.commands = new NormalModeCommands(this.agent);
        this.agentCommandDictionaryService.addCommandSetToObject(this.commands, this.agent);
    }

    public NormalModeCommands getCommands() {
        return this.commands;
    }

    public class NormalModeCommands {
        private final AgentStateService stateService;
        private final Agent agent;

        NormalModeCommands(Agent agent) {
            this.agent = agent;
            this.stateService = agent.getAgentService(AgentStateService.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Command(description="switch to ENGINEERING mode", type=Command.CommandType.ACTION, category=Command.CommandCategory.CORE, autoAck=false, level=0)
        public void switchToEngineeringMode() {
            Object object = this.stateService.getStateLock();
            synchronized (object) {
                this.agent.helper().precondition(this.stateService.isInState((Enum)OperationalState.NORMAL), "Switching to Engineering mode is allowed only when the OperationalState is NORMAL. The Agent is currently in OperationalState: %s", this.stateService.getState(OperationalState.class)).action(() -> this.stateService.updateInternalState(new AgentState[]{OperationalState.ENGINEERING_OK}));
            }
        }

        @Command(description="Tries to get back to NORMAL mode", type=Command.CommandType.ACTION, category=Command.CommandCategory.CORE, autoAck=false, level=0)
        public void switchToNormalMode() {
            String agentVeto = this.agent.vetoTransitionToNormalMode();
            this.agent.helper().precondition(this.stateService.isInState((Enum)ConfigurationState.CONFIGURED), "Switching to Normal mode is allowed only when the ConfigurationState is CONFIGURED. The Agent is currently in ConfigurationState: %s", this.stateService.getState(ConfigurationState.class)).precondition(this.stateService.getState(AlertState.class).compareTo(AlertState.WARNING) <= 0, "Switching to Normal mode is not allowed when the AlertState is ALARM: %s", this.stateService.getState(AlertState.class)).precondition(this.agent.getCommandCount(new Command.CommandType[]{Command.CommandType.SIGNAL}) == 0, "Switching to Normal mode is not allowed when SIGNAL commands are running.", new Supplier[0]).precondition(agentVeto == null, agentVeto, new Supplier[0]).action(() -> {
                try {
                    this.stateService.updateInternalState(new AgentState[]{OperationalState.NORMAL});
                }
                catch (IllegalArgumentException x) {
                    throw new SystemStateException(x);
                }
            });
        }
    }
}

