/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Publisher
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(Publisher.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @ConfigurationParameter(isFinal=true, description="The name of the subsystem configuration in effect.", units="unitless")
    private volatile String configurationName = "<No config>";
    @ConfigurationParameter(description="The interval between regular status publications.", units="s")
    private volatile Duration publicationInterval = Duration.ofSeconds(1L);
    private ShutterStatus shutterStat;
    private ControllerStatus controllerStat;
    private Map<Axis, AxisStatus> axisStat;
    private PlatformConfig config;
    private Scheduler publicationScheduler;
    private PeriodicTask publicationTask;

    public void init() {
        List axisNames = Stream.of(Axis.values()).map(Axis::getName).collect(Collectors.toList());
        List axisUnits = Stream.of(Axis.values()).map(x -> "mm").collect(Collectors.toList());
        List capture = Collections.emptyList();
        List digitalInputNames = Collections.emptyList();
        List digitalOutputNames = Collections.emptyList();
        List analogInputDescriptions = Collections.emptyList();
        this.config = new PlatformConfig(axisNames, capture, digitalInputNames, digitalOutputNames, analogInputDescriptions, this.configurationName, axisUnits);
        this.axisStat = new TreeMap<Axis, AxisStatus>();
        this.controllerStat = new ControllerStatus(ContactStatus.DOWN.toString(), false, CommandStatus.UNKNOWN.toString());
    }

    public synchronized void postStart() {
        this.publicationScheduler = new Scheduler("Status publication", 1);
        this.publicationScheduler.setLogger(LOG);
        this.publicationScheduler.setDefaultLogLevel(Level.SEVERE);
        LOG.info("Starting the publication task.");
        this.publicationTask = this.publicationScheduler.scheduleWithFixedDelay(this::publicationTaskBody, 0L, this.publicationInterval.toMillis(), TimeUnit.MILLISECONDS);
        this.config = new PlatformConfig(this.config.getAxisNames(), this.config.getCapture(), this.config.getDigitalInputNames(), this.config.getDigitalOutputNames(), this.config.getAnalogInputDescriptions(), this.configurationName, this.config.getAxisUnits());
        this.publishConfiguration();
    }

    public synchronized void shutdown() {
        LOG.info("Normal stop of the publication task.");
        this.publicationScheduler.shutdownNow();
    }

    synchronized void updateShutterStatus(ShutterStatus shutterStat) {
        this.shutterStat = shutterStat;
    }

    synchronized ShutterStatus getShutterStatus() {
        return this.shutterStat;
    }

    synchronized AxisStatus getAxisStatus(String axisName) {
        assert (axisName != null);
        Axis ax = Axis.fromName(axisName);
        assert (ax != null);
        return this.axisStat.get((Object)ax);
    }

    synchronized void setContactStatus(ContactStatus stat) {
        assert (stat != null);
        this.controllerStat = new ControllerStatus(stat.toString(), this.controllerStat.isMotionEnabled(), stat == ContactStatus.UP ? this.controllerStat.getLastCommandStatus() : CommandStatus.UNKNOWN.toString());
    }

    synchronized void setEnableStatus(boolean motionEnabled) {
        this.controllerStat = new ControllerStatus(this.controllerStat.getCommLinkStatus(), motionEnabled, this.controllerStat.getLastCommandStatus());
    }

    synchronized void setCommandStatus(CommandStatus stat) {
        assert (stat != null);
        this.controllerStat = new ControllerStatus(this.controllerStat.getCommLinkStatus(), this.controllerStat.isMotionEnabled(), stat.toString());
    }

    synchronized void publishBrakePowerStatus(boolean powerIsOn) {
        TreeMap<ShutterSide, ShutterStatus.ShutterAxisStatus> axes = new TreeMap<ShutterSide, ShutterStatus.ShutterAxisStatus>();
        axes.put(ShutterSide.PLUSX, this.shutterStat.getAxisStatus(ShutterSide.PLUSX));
        axes.put(ShutterSide.MINUSX, this.shutterStat.getAxisStatus(ShutterSide.MINUSX));
        this.shutterStat = new ShutterStatus(this.shutterStat.getMotionProfile(), this.shutterStat.isCalibrated(), this.shutterStat.getSmState(), axes, this.shutterStat.isSafetyOn(), this.shutterStat.getTemperature(), this.shutterStat.getTempIsSafe(), powerIsOn, CCSTimeStamp.currentTime(), this.shutterStat.getPtpState(), this.shutterStat.getLeapSeconds(), this.shutterStat.isLeapValid());
        this.publish(this.shutterStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publicationTaskBody() {
        ArrayList<AxisStatus> axis;
        ControllerStatus controller;
        ShutterStatus shutter;
        Publisher publisher = this;
        synchronized (publisher) {
            if (this.shutterStat == null) {
                return;
            }
            this.controllerStat = new ControllerStatus(ContactStatus.UP.toString(), this.controllerStat.isMotionEnabled(), this.controllerStat.getLastCommandStatus());
            for (Axis ax : Axis.values()) {
                ShutterStatus.ShutterAxisStatus plcStat = this.shutterStat.getAxisStatus(ShutterSide.fromAxis(ax));
                AxisStatus mpStat = new AxisStatus(ax.getName(), plcStat.isEnabled(), plcStat.getActVel() != 0.0, plcStat.isHomed(), plcStat.atLowLimit(), plcStat.atHighLimit(), plcStat.getErrorID() == 0 ? Collections.emptyList() : Arrays.asList("Error " + plcStat.getErrorID()), plcStat.getActPos());
                this.axisStat.put(ax, mpStat);
            }
            shutter = this.shutterStat;
            controller = this.controllerStat;
            axis = new ArrayList<AxisStatus>(this.axisStat.values());
        }
        this.publish(shutter);
        this.publish((Serializable)controller);
        for (AxisStatus ax : axis) {
            this.publish((Serializable)ax);
        }
    }

    public void publish(Serializable msg) {
        if (msg != null) {
            this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData(msg.getClass().getSimpleName(), msg));
        }
    }

    void publishControllerStatus() {
        this.publish((Serializable)this.getControllerStatus());
    }

    private synchronized ControllerStatus getControllerStatus() {
        return this.controllerStat;
    }

    void publishConfiguration() {
        this.publish((Serializable)this.getConfiguration());
    }

    private synchronized PlatformConfig getConfiguration() {
        return this.config;
    }

    void publishAxisStatus(String axisName) {
        AxisStatus stat = this.getAxisStatus(axisName);
        this.publish((Serializable)stat);
    }

    public void publishMotionDone(MotionDone motion) {
        this.publish(motion);
    }

    private synchronized void setShutterStatus(ShutterStatus shutter) {
        this.shutterStat = shutter;
    }

    static enum ContactStatus {
        UP,
        DOWN;

    }

    static enum CommandStatus {
        UNKNOWN,
        SENT,
        ACKED,
        FAILED;

    }
}

