/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freehep.application.studio.LibInfo;
import org.freehep.application.studio.PluginInfo;

public class PluginException
extends RuntimeException {
    private ArrayList<String> missingLibraries;
    private ArrayList<String> missingPlugins;

    public PluginException() {
    }

    public PluginException(String string) {
        super(string);
    }

    public PluginException(String string, Throwable thrwbl) {
        super(string, thrwbl);
    }

    public PluginException(Throwable thrwbl) {
        super(thrwbl);
    }

    public PluginException(PluginInfo plugin) {
        this.missingPlugins = new ArrayList(1);
        this.missingPlugins.add(plugin.getName());
    }

    public PluginException(LibInfo library) {
        this.missingLibraries = new ArrayList(1);
        this.missingLibraries.add(library.getId());
    }

    public static boolean reportMissingPlugin(PluginInfo plugin, String missing) {
        Throwable t = plugin.getErrorStatus();
        if (t instanceof PluginException) {
            PluginException pe = (PluginException)t;
            if (pe.missingPlugins == null) {
                pe.missingPlugins = new ArrayList(1);
            } else {
                pe.missingPlugins.ensureCapacity(pe.missingPlugins.size() + 1);
            }
            pe.missingPlugins.add(missing);
        } else {
            PluginException pe = t == null ? new PluginException() : new PluginException(t);
            pe.missingPlugins = new ArrayList(1);
            pe.missingPlugins.add(missing);
            plugin.setErrorStatus(pe);
        }
        return t == null;
    }

    public static boolean reportNoMissingPlugins(PluginInfo plugin) {
        Throwable t = plugin.getErrorStatus();
        if (t instanceof PluginException) {
            PluginException pe = (PluginException)t;
            if (pe.missingPlugins == null) {
                return false;
            }
            pe.missingPlugins = null;
            if (pe.hasNothingToReport()) {
                t = pe.getCause();
                plugin.setErrorStatus(t);
            }
            return t == null;
        }
        return false;
    }

    public static boolean reportMissingLibrary(PluginInfo plugin, String missing) {
        Throwable t = plugin.getErrorStatus();
        if (t instanceof PluginException) {
            PluginException pe = (PluginException)t;
            if (pe.missingLibraries == null) {
                pe.missingLibraries = new ArrayList(1);
            } else {
                pe.missingLibraries.ensureCapacity(pe.missingLibraries.size() + 1);
            }
            pe.missingLibraries.add(missing);
        } else {
            PluginException pe = t == null ? new PluginException() : new PluginException(t);
            pe.missingLibraries = new ArrayList(1);
            pe.missingLibraries.add(missing);
            plugin.setErrorStatus(pe);
        }
        return t == null;
    }

    public static boolean reportNoMissingLibraries(PluginInfo plugin) {
        Throwable t = plugin.getErrorStatus();
        if (t instanceof PluginException) {
            PluginException pe = (PluginException)t;
            if (pe.missingLibraries == null) {
                return false;
            }
            pe.missingLibraries = null;
            if (pe.hasNothingToReport()) {
                t = pe.getCause();
                plugin.setErrorStatus(t);
            }
            return t == null;
        }
        return false;
    }

    public List<String> getMissingLibraries() {
        return this.missingLibraries == null ? Collections.emptyList() : Collections.unmodifiableList(this.missingLibraries);
    }

    public List<String> getMissingPlugins() {
        return this.missingPlugins == null ? Collections.emptyList() : Collections.unmodifiableList(this.missingPlugins);
    }

    protected boolean hasNothingToReport() {
        return this.missingLibraries == null && this.missingPlugins == null;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("\n");
        if (this.missingPlugins != null && !this.missingPlugins.isEmpty()) {
            sb.append("\nMissing, incompatible, or broken required plugins:\n");
            for (String name : this.missingPlugins) {
                sb.append(name).append("\n");
            }
        }
        if (this.missingLibraries != null && !this.missingLibraries.isEmpty()) {
            sb.append("\nMissing libraries:\n");
            for (String name : this.missingLibraries) {
                sb.append(name).append("\n");
            }
        }
        return sb.toString();
    }
}

