/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.direct;

import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.lsst.ccs.utilities.image.direct.DirectByteBufferCacheMBean;

public class DirectByteBufferCache
implements DirectByteBufferCacheMBean {
    private static final Logger LOG = Logger.getLogger(DirectByteBufferCache.class.getName());
    private final Map<Integer, Queue<ByteBuffer>> byteBufferCache = new ConcurrentHashMap<Integer, Queue<ByteBuffer>>();
    private final AtomicInteger bufferCount = new AtomicInteger();
    private final AtomicLong totalCapacity = new AtomicLong();
    private final AtomicInteger inUseCount = new AtomicInteger();
    private final AtomicLong inUseCapacity = new AtomicLong();
    private static final DirectByteBufferCache theInstance = new DirectByteBufferCache();

    private DirectByteBufferCache() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("org.lsst.ccs.utilities.image:name=DirectByteBufferCache");
            mbs.registerMBean(this, name);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException x) {
            LOG.log(Level.WARNING, "Failed to register mbean", x);
        }
    }

    public static DirectByteBufferCache instance() {
        return theInstance;
    }

    public ByteBuffer allocateDirect(int capacity) {
        Queue cachedByteBuffers = this.byteBufferCache.computeIfAbsent(capacity, s -> new LinkedBlockingQueue());
        ByteBuffer bb = (ByteBuffer)cachedByteBuffers.poll();
        if (bb == null) {
            bb = ByteBuffer.allocateDirect(capacity);
            this.bufferCount.incrementAndGet();
            this.totalCapacity.addAndGet(capacity);
        }
        this.inUseCount.incrementAndGet();
        this.inUseCapacity.addAndGet(capacity);
        return bb;
    }

    public void free(ByteBuffer byteBuffer) {
        int capacity = byteBuffer.capacity();
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        Queue<ByteBuffer> cachedByteBuffers = this.byteBufferCache.get(capacity);
        cachedByteBuffers.add(byteBuffer);
        this.inUseCount.decrementAndGet();
        this.inUseCapacity.addAndGet(-capacity);
    }

    public String toString() {
        return "DirectByteBufferCache{byteBufferCache=" + this.getBufferSizeAndCounts() + ", bufferCount=" + this.bufferCount + ", totalCapacity=" + this.totalCapacity + ", inUseCount=" + this.inUseCount + ", inUseCapacity=" + this.inUseCapacity + '}';
    }

    @Override
    public int getBufferCount() {
        return this.bufferCount.get();
    }

    @Override
    public long getTotalCapacity() {
        return this.totalCapacity.get();
    }

    @Override
    public int getInUseCount() {
        return this.inUseCount.get();
    }

    @Override
    public long getInUseCapacity() {
        return this.inUseCapacity.get();
    }

    @Override
    public int getByteBufferCacheSize() {
        return this.byteBufferCache.size();
    }

    @Override
    public Map<Integer, Integer> getBufferSizeAndCounts() {
        return this.byteBufferCache.entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> ((Queue)e.getValue()).size()));
    }
}

