/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.LoaderClamp;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.RejectedCommandException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuLoaderPlutoGateway;

public class SimuLoaderClampController
extends SimuEPOSController {
    private static final Logger FCSLOG = Logger.getLogger(SimuLoaderClampController.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter=".*\\/hooks")
    private LoaderClamp clamp;
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    private SimuLoaderPlutoGateway plutoGateway;
    @LookupPath
    private String nodePath;
    static int POSITION_CLAMPED = 350000;
    static int POSITION_OPENED = 0;

    @Override
    public void init() {
        if (this.plutoGateway == null) {
            throw new RuntimeException("Invalid initialization. An instance of SimuAutochangerPlutoGateway should have been picked up from the Lookup tree from the siblings of this node: " + this.nodePath);
        }
    }

    @Override
    public void writeCurrent(int aValue) {
        this.targetCurrent = aValue;
        int currentInitial = this.actualCurrent;
        FCSLOG.finer("=>initial current=" + this.actualCurrent);
        int stepsNB = 10;
        int step = (this.targetCurrent - this.actualCurrent) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.actualCurrent = (short)(currentInitial + i * step);
            if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
                FCSLOG.finer("plutoGateway=" + this.plutoGateway.toString());
                this.position = POSITION_CLAMPED;
                this.plutoGateway.simulateLoaderClampIsClosed();
            } else if (this.actualCurrent == this.clamp.getCurrentToOpen()) {
                this.position = POSITION_OPENED;
                this.plutoGateway.simulateLoaderClampIsOpened();
            }
            this.clamp.publishData();
            FCSLOG.finer("i=" + i + ",actualCurrent=" + this.actualCurrent);
            try {
                Thread.sleep(10L);
                if (!this.clamp.getHaltRequired().get()) continue;
                FCSLOG.finer(this.name + " STOP simulated clamp motion.");
                return;
            }
            catch (InterruptedException ex) {
                throw new FcsHardwareException(this.name + " sleep was interrupted.", ex);
            }
        }
        this.actualCurrent = aValue;
        if (this.actualCurrent == this.clamp.getCurrentToClamp()) {
            FCSLOG.finer("plutoGateway=" + this.plutoGateway.toString());
            this.position = POSITION_CLAMPED;
            this.plutoGateway.simulateLoaderClampIsClamped();
        } else if (this.actualCurrent == this.clamp.getCurrentToOpen()) {
            this.position = POSITION_OPENED;
            this.plutoGateway.simulateLoaderClampIsOpened();
        }
        this.clamp.publishData();
    }

    @Override
    public void writeTargetPosition(int positionToReached) {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.info("=>initialPosition=" + this.position);
        FCSLOG.info("=>targetPosition=" + this.targetPosition);
        FCSLOG.info("clamp.getTargetPositionToClamp()=" + POSITION_CLAMPED);
        FCSLOG.info("clamp.getRelativePositionToUnclamp()=" + this.clamp.getRelativePositionToUnclamp());
        int stepsNB = 10;
        int step = (this.targetPosition - this.position) / stepsNB;
        for (int i = 1; i < stepsNB; ++i) {
            this.position = positionInitiale + i * step;
            this.clamp.updatePosition();
            this.simulateSensors();
            FCSLOG.info("i=" + i + ",position=" + this.position);
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException ex) {
                throw new RejectedCommandException(this.name + " sleep was interrupted.");
            }
        }
        this.position = this.targetPosition;
        FCSLOG.info("i=10,position=" + this.position);
        this.simulateSensors();
    }

    private void simulateSensors() {
        if (this.position == POSITION_OPENED) {
            FCSLOG.finer("plutoGateway=" + this.plutoGateway.toString());
            this.plutoGateway.simulateLoaderClampIsOpened();
        } else if (this.position == this.clamp.getRelativePositionToClose() || this.position == POSITION_CLAMPED + this.clamp.getRelativePositionToUnclamp()) {
            this.plutoGateway.simulateLoaderClampIsClosed();
        } else if (this.position == POSITION_CLAMPED) {
            this.plutoGateway.simulateLoaderClampIsClamped();
        } else {
            this.plutoGateway.simulateLoaderClampIsInTravel();
        }
        this.clamp.publishData();
    }

    @Override
    public void changeMode(EPOSEnumerations.EposMode newmode) {
        super.changeMode(newmode);
        if (EPOSEnumerations.EposMode.HOMING.equals((Object)newmode)) {
            this.writeCurrent(this.clamp.getCurrentToOpen());
        }
    }
}

