/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Tools {
    public static long UTC_SECONDS_YEAR_2000 = 946684800L;

    public static boolean getBoolean(ByteBuffer data) {
        return data.get() != 0;
    }

    public static void putBoolean(ByteBuffer data, boolean b) {
        data.put(b ? (byte)1 : 0);
    }

    public static CCSTimeStamp fromDcTime64(long dctime64, int dtai) {
        long seconds = Long.divideUnsigned(dctime64, 1000000000L);
        long nanos = dctime64 - 1000000000L * seconds;
        Instant inst = Instant.ofEpochSecond(seconds, nanos).plusSeconds(UTC_SECONDS_YEAR_2000);
        return CCSTimeStamp.fromTAI((Instant)inst, (int)dtai);
    }

    public static long toDcTime64(CCSTimeStamp ccsTime) {
        Instant tai = ccsTime.getTAIInstant();
        long seconds = tai.minusSeconds(UTC_SECONDS_YEAR_2000).getEpochSecond();
        long nanos = tai.getNano();
        return seconds * 1000000000L + nanos;
    }

    public static Duration fromDcDuration(long dcNanos) {
        return Duration.ofNanos(dcNanos);
    }

    public static long toDcDuration(Duration interval) {
        return interval.toNanos();
    }

    public static void main(String[] args) {
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        int tdai = (int)Duration.between(now.getUTCInstant(), now.getTAIInstant()).getSeconds();
        System.out.println("TDAI (seconds): " + Integer.toString(tdai));
        long dcNow = Tools.toDcTime64(now);
        CCSTimeStamp now2 = Tools.fromDcTime64(dcNow, tdai);
        System.out.println("Original CCS timestamp: " + now.toString());
        System.out.println("Converted to T_DCTIME64: 0x" + Long.toHexString(dcNow));
        System.out.println("Converted back to CCS timestamp: " + now2.toString());
    }
}

