/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.daq;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Folder;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.daq.ims.Utils;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class DaqStoreManageDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private static final Logger LOG = Logger.getLogger(DaqStoreManageDevice.class.getName());
    private static final Pattern PATH_PATTERN = Pattern.compile("([0-9a-zA-Z\\-\\_]*)/?([0-9a-zA-Z\\-\\_]*)");
    private final double DAQ_UNITS = 1.0E9;
    private String partition;
    private Store store;
    private Map<Integer, String> chanMap = new HashMap<Integer, String>();
    private Integer chanKey;
    @ConfigurationParameter(isFinal=true, category="Store", units="unitless", description="top-level folder for DAQ store")
    private volatile String daqFolder;
    @ConfigurationParameter(category="Store", units="unitless", description="fraction of used disk space to trigger a store purge")
    private volatile Double purgeThreshold;
    @ConfigurationParameter(category="Store", units="unitless", description="goal of purge for maximum fractional disk space used")
    private volatile Double purgeTarget;
    @ConfigurationParameter(category="Store", units="unitless", description="enable automatic purge of DAQ store")
    private volatile Boolean enableAutoPurge;

    void setPartition(String pname) {
        this.partition = pname;
    }

    protected void initDevice() {
        this.chanKey = 0;
        if (this.daqFolder == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"daqFolder", (String)"is missing");
        }
        if (this.purgeThreshold == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"purgeThreshold", (String)"is missing");
        }
        if (this.purgeTarget == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"purgeTarget", (String)"is missing");
        }
        if (this.enableAutoPurge == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"enableAutoPurge", (String)"value is missing");
        }
    }

    protected void initialize() {
        this.fullName = this.name + ": (partition " + this.partition + ")";
        try {
            if (this.store != null) {
                this.store.close();
            }
            this.store = new Store(this.partition);
            this.initSensors();
            this.setOnline(true);
            LOG.info("\n Connected to " + this.fullName);
        }
        catch (DAQException ex) {
            if (!this.inited) {
                throw new RuntimeException("DAQException while connecting to or initializing " + this.fullName + ": " + ex.getMessage());
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
        }
        catch (DAQException ex) {
            throw new RuntimeException("DAQException while closing " + this.fullName + ": " + ex.getMessage());
        }
    }

    private void checkStore() {
        if (this.store == null) {
            throw new RuntimeException("Please connect to store first");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="purgeThreshold")
    public void setPurgeThreshold(Double fraction) throws DAQException {
        if (this.isOnline()) {
            if (fraction == null) throw new IllegalArgumentException(this.name + ": improper value for purgeThreshold, not changed");
            this.log.info((Object)(this.name + "config. change request: set PURGE_THRESHOLD to " + Double.toString(fraction)));
            this.purgeThreshold = fraction;
            return;
        } else {
            if (fraction == null) return;
            this.purgeThreshold = fraction;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ConfigurationParameterChanger(propertyName="purgeTarget")
    public void setPurgeTarget(Double fraction) throws DAQException {
        if (this.isOnline()) {
            if (fraction == null) throw new IllegalArgumentException(this.name + ": improper value for purgeTarget, not changed");
            this.log.info((Object)(this.name + "config. change request: set PURGE_TARGET to " + Double.toString(fraction)));
            this.purgeTarget = fraction;
            return;
        } else {
            if (fraction == null) return;
            this.purgeTarget = fraction;
        }
    }

    protected int[] checkChannel(String chName, int hwChan, String type, String subtype) throws Exception {
        try {
            MonChan.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)chName, (String)"type", (Object)type);
        }
        Integer n = this.chanKey;
        Integer n2 = this.chanKey = Integer.valueOf(this.chanKey + 1);
        this.chanMap.put(this.chanKey, type);
        return new int[]{this.chanKey, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double remaining;
        double capacity;
        double value = super.readChannel(hwChan, type);
        String chanName = this.chanMap.get(type);
        try {
            capacity = this.store.getCapacity();
            remaining = this.store.getRemaining();
        }
        catch (DAQException e) {
            throw new RuntimeException("DAQException while reading file storage space " + this.fullName + ": " + e.getMessage());
        }
        if (chanName.equals("DAQ_CAPACITY")) {
            value = capacity / 1.0E9;
            if (capacity <= 0.0) {
                value = Double.NaN;
            }
        } else if (chanName.equals("DAQ_REMAINING")) {
            value = remaining / 1.0E9;
        } else if (chanName.equals("DAQ_FREE_FRACTION")) {
            value = capacity <= 0.0 ? Double.NaN : remaining / capacity;
        }
        return value;
    }

    private Image imageFromPath(Matcher matcher) throws DAQException {
        Folder folder = this.store.getCatalog().find(matcher.group(1));
        if (folder == null) {
            throw new RuntimeException("No such folder: " + matcher.group(1));
        }
        Image image = folder.find(matcher.group(2));
        if (image == null) {
            throw new RuntimeException("No such image: " + matcher.group(2));
        }
        return image;
    }

    private double spaceUsage() throws DAQException {
        double capacity = this.store.getCapacity();
        double remaining = this.store.getRemaining();
        return 1.0 - remaining / capacity;
    }

    @Command(type=Command.CommandType.QUERY, name="list", alias="ls", level=0, description="List DAQ partition contents", timeout=30)
    public String list(@Argument(name="path", description="<default=\"\"|folder|folder/file>", defaultValue="") String path) throws DAQException {
        this.checkStore();
        return Utils.list((Store)this.store, (String)path).collect(Collectors.joining("\n"));
    }

    synchronized void purge() throws DAQException {
        double fracAfter;
        double fracDiff;
        this.checkStore();
        Folder folder = this.store.getCatalog().find(this.daqFolder);
        if (folder == null) {
            throw new IllegalArgumentException("Invalid folder: " + folder);
        }
        double fracBefore = this.spaceUsage();
        LOG.info(this.name + " purge requested, utilized space fraction = " + Double.toString(fracBefore));
        List images = folder.listImages();
        images.sort((i1, i2) -> i1.getMetaData().getTimestamp().compareTo(i2.getMetaData().getTimestamp()));
        for (Image image : images) {
            if (!(this.spaceUsage() > this.purgeTarget)) break;
            LOG.info("Deleting: " + image.getMetaData().getName());
            image.delete();
        }
        if (!Double.isFinite(fracDiff = fracBefore - (fracAfter = this.spaceUsage()))) {
            fracDiff = Double.NaN;
        }
        KeyValueData purged = new KeyValueData("store/purgedSpaceFraction", (Serializable)Double.valueOf(fracDiff));
        this.agent.publishSubsystemDataOnStatusBus(purged);
        LOG.info(this.name + " after purge, utilized space fraction = " + Double.toString(fracAfter));
    }

    void autoPurge() throws DAQException {
        if (!this.enableAutoPurge.booleanValue()) {
            return;
        }
        this.checkStore();
        double usage = this.spaceUsage();
        if (usage > this.purgeThreshold) {
            LOG.info(this.name + " autoPurge initiated");
            this.purge();
        } else {
            LOG.info(this.name + "autoPurge requested,a but space usage " + Double.toString(usage) + " is below purgeThreshold " + this.purgeThreshold.toString());
        }
    }

    public static enum MonChan {
        DAQ_CAPACITY,
        DAQ_REMAINING,
        DAQ_FREE_FRACTION;

    }
}

