/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.protocol.websocket;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.indilib.i4j.protocol.api.INDIConnection;
import org.indilib.i4j.protocol.api.INDIInputStream;
import org.indilib.i4j.protocol.api.INDIOutputStream;
import org.indilib.i4j.protocol.io.INDIProtocolFactory;
import org.indilib.i4j.protocol.url.INDIURLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDIWebSocketConnection
implements INDIConnection {
    private static final Logger LOG;
    private INDIInputStream inputStream;
    private INDIOutputStream ouputStream;
    private Session session;

    public INDIWebSocketConnection(Session session) {
        this.session = session;
        try {
            this.createINDIInputStream();
            this.createINDIOutPutStream();
        }
        catch (IOException e) {
            LOG.error("cound not create INDI streams on websocket endpoint", (Throwable)e);
            try {
                this.close();
            }
            catch (IOException e1) {
                LOG.warn("cound not close websocket endpoint properly", (Throwable)e1);
            }
        }
    }

    @Override
    public INDIInputStream getINDIInputStream() throws IOException {
        return this.inputStream;
    }

    protected void createINDIInputStream() throws IOException {
        PipedInputStream bytesIn = new PipedInputStream();
        final PipedOutputStream bytesOut = new PipedOutputStream(bytesIn);
        this.inputStream = INDIProtocolFactory.createINDIInputStream(bytesIn);
        this.session.addMessageHandler((MessageHandler)new MessageHandler.Partial<byte[]>(){

            public void onMessage(byte[] message, boolean last) {
                try {
                    bytesOut.write(message);
                    bytesOut.flush();
                }
                catch (IOException e) {
                    LOG.error("cound not create INDI input stream on websocket endpoint", (Throwable)e);
                    try {
                        INDIWebSocketConnection.this.close();
                    }
                    catch (IOException e1) {
                        LOG.warn("cound not close websocket endpoint properly", (Throwable)e1);
                    }
                }
            }
        });
    }

    @Override
    public INDIOutputStream getINDIOutputStream() throws IOException {
        return this.ouputStream;
    }

    protected void createINDIOutPutStream() throws IOException {
        this.ouputStream = INDIProtocolFactory.createINDIOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                byte[] bytes = new byte[]{(byte)b};
                INDIWebSocketConnection.this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                INDIWebSocketConnection.this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                INDIWebSocketConnection.this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes, off, len));
            }

            @Override
            public void flush() throws IOException {
                INDIWebSocketConnection.this.session.getBasicRemote().sendBinary(ByteBuffer.wrap(new byte[0]), true);
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.ouputStream.close();
        this.session.close();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.session.getRequestURI() + ")";
    }

    @Override
    public URL getURL() {
        try {
            return this.session.getRequestURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.error("illegal std url, should never happen!", (Throwable)e);
            return null;
        }
    }

    static {
        INDIURLStreamHandlerFactory.init();
        LOG = LoggerFactory.getLogger(INDIWebSocketConnection.class);
    }
}

