/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

public class PIController {
    private double gain = 15.0;
    private double timeConst;
    private double smoothTime = 100.0;
    private double maxOutput = 130.0;
    private double minOutput = 0.0;
    private double maxInput = 0.0;
    private double minInput = 0.0;
    private double tolerance = 0.1;
    private double setpoint = 140.0;
    private double awgain = 4.0;
    private double baseOutput = 0.0;
    private double aveInput;
    private double smoothInput;
    private double measTime;
    private double lastTime = 0.0;
    private double errorIntegral = 0.0;
    private double setError = 0.0;

    public PIController(double Init_gain, double Init_timeConstant) {
        this.gain = Init_gain;
        this.timeConst = Init_timeConstant;
    }

    public double performPI(double[] input, double time) {
        this.aveInput = 0.0;
        for (double mInput : input) {
            this.aveInput += mInput / (double)input.length;
        }
        this.measTime = time;
        return this.calculate();
    }

    public void setPID(double p, double intTime) {
        this.gain = p;
        this.timeConst = intTime;
    }

    public double getP() {
        return this.gain;
    }

    public double getI() {
        return this.timeConst;
    }

    public void setSmoothTime(double time) {
        this.smoothTime = time;
    }

    public void setAwGain(double gain) {
        this.awgain = gain;
    }

    public void setBaseOutput(double value) {
        this.baseOutput = value;
    }

    public void setTolerance(double percent) {
        this.tolerance = percent;
    }

    public void setInputRange(double minimumInput, double maximumInput) {
        this.minInput = minimumInput;
        this.maxInput = maximumInput;
        this.setSetpoint(this.setpoint);
    }

    public void setOutputRange(double minimumOutput, double maximumOutput) {
        this.minOutput = minimumOutput;
        this.maxOutput = maximumOutput;
    }

    public void setSetpoint(double setpnt) {
        this.setpoint = this.maxInput <= this.minInput ? setpnt : (setpnt > this.maxInput ? this.maxInput : (setpnt < this.minInput ? this.minInput : setpnt));
    }

    public double getSetpoint() {
        return this.setpoint;
    }

    public double getError() {
        return this.setError;
    }

    public double getIntegral() {
        return this.errorIntegral;
    }

    public void setIntegral(double value) {
        this.errorIntegral = value;
    }

    public double getSmooth() {
        return this.smoothInput;
    }

    public boolean onTarget() {
        return Math.abs(this.setError) < this.tolerance / 100.0 * (this.maxInput - this.minInput);
    }

    public void reset() {
        this.errorIntegral = 0.0;
        this.lastTime = 0.0;
    }

    private double calculate() {
        if (this.lastTime == 0.0) {
            this.lastTime = this.measTime - 1.0;
            this.smoothInput = this.aveInput;
        }
        this.smoothInput = ((this.measTime - this.lastTime) * this.aveInput + (this.smoothTime - this.measTime + this.lastTime) * this.smoothInput) / this.smoothTime;
        this.setError = this.setpoint - this.smoothInput;
        double smoothOutput = this.gain * this.setError;
        double propInt = smoothOutput + this.errorIntegral;
        double output = propInt > this.maxOutput ? this.maxOutput : (propInt < this.minOutput ? this.minOutput : propInt);
        double outputTrunc = this.awgain * (output - propInt);
        this.errorIntegral += (smoothOutput + outputTrunc) * (this.measTime - this.lastTime) / this.timeConst;
        this.lastTime = this.measTime;
        return output + this.baseOutput;
    }
}

