/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class HeatTransferChannel
extends DerivedChannel {
    @LookupField(strategy=LookupField.Strategy.TREE)
    Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(HeatTransferChannel.class.getName());
    private double factor = 1.0;
    private Channel flowChannel;
    private Channel inletTChannel;
    private Channel outletTChannel;
    @ConfigurationParameter(name="flowChanPath", category="General", isFinal=true, units="unitless", description="path to flow-rate Channel")
    protected volatile String flowChanPath;
    @ConfigurationParameter(name="inletTChanPath", category="General", isFinal=true, units="unitless", description="Path to inlet temperature Channel")
    protected volatile String inletTChanPath;
    @ConfigurationParameter(name="outletTChanPath", category="General", isFinal=true, units="unitless", description="Path to outlet temperature Channel")
    protected volatile String outletTChanPath;

    public void validateBulkChange(Map<String, Object> params) {
        super.validateBulkChange(params);
        String chpath = (String)params.get("flowChanPath");
        if (this.channelMap.get(chpath) == null) {
            throw new RuntimeException(this.name + ": flowChanPath " + chpath + " not found");
        }
        chpath = (String)params.get("inletTChanPath");
        if (this.channelMap.get(chpath) == null) {
            throw new RuntimeException(this.name + ": inletTChanPath " + chpath + " not found");
        }
        chpath = (String)params.get("outletTChanPath");
        if (this.channelMap.get(chpath) == null) {
            throw new RuntimeException(this.name + ": outletTChanPath " + chpath + " not found");
        }
    }

    public void setParameterBulk(Map<String, Object> params) {
        super.setParameterBulk(params);
        Set<String> keys = params.keySet();
        if (keys.contains("flowChanPath")) {
            this.flowChanPath = (String)params.get("flowChanPath");
            this.flowChannel = this.channelMap.get(this.flowChanPath);
        }
        if (keys.contains("inletTChanPath")) {
            this.inletTChanPath = (String)params.get("inletTChanPath");
            this.inletTChannel = this.channelMap.get(this.inletTChanPath);
        }
        if (keys.contains("outletTChanPath")) {
            this.outletTChanPath = (String)params.get("outletTChanPath");
            this.outletTChannel = this.channelMap.get(this.outletTChanPath);
        }
    }

    public void setFactor(double fac) {
        this.factor = fac;
        LOG.info(this.name + ": Constant factor set to " + this.factor);
    }

    public double evaluateDerivedValue() {
        double trans = (this.outletTChannel.getValue() - this.inletTChannel.getValue()) * this.flowChannel.getValue() * this.factor;
        return trans;
    }
}

