/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.camera.Camera;
import org.lsst.ccs.camera.sal.classes.SALClassDescription;
import org.lsst.ccs.camera.sal.classes.SALClassDescriptionMaker;
import org.lsst.ccs.camera.sal.xml.MakeXMLConfiguration;
import org.lsst.ccs.camera.sal.xml.Mapping;
import org.lsst.ccs.camera.sal.xml.XMLMaker2;
import org.lsst.ccs.subsystem.ocsbridge.util.ClassUtils;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericConverter {
    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());
    private final List<String> mia = new ArrayList<String>();
    private final Map<Class, List<String>> alreadyWarned = new HashMap<Class, List<String>>();
    private final List<String> subsystemsToConvert = new ArrayList<String>();
    private final List<String> componentNames = new ArrayList<String>();
    private final Mapping mapping = Mapping.defaultMapping();
    private final XMLMaker2.SALType salType;
    private final Camera camera;
    private final Map<String, SALClassDescriptionMaker> salClassDescriptionMakerMap = new ConcurrentHashMap<String, SALClassDescriptionMaker>();
    private static final boolean DEBUG_PRINT_TRENDING = false;
    private static final boolean DEBUG_PRINT_SETTINGS = false;
    private static final boolean DEBUG_PRINT_REFLECTION = false;
    private static final boolean DEBUG_PRINT_BADVALUES = false;
    private static final boolean DEBUG_PRINT_RETURNBUSDATA = false;
    private static final boolean DEBUG_PRINT_DATA_NAMES_AND_VALUES = false;
    private static final boolean logAndContinueOnConversionError = true;
    boolean badBValue = false;
    double badDValue = Double.NaN;
    int badIValue = -111111111;
    float badFValue = Float.NaN;
    String badStringValue = "NOTFOUND";
    long badLValue = -111111111L;
    short badSValue = (short)-11111;

    public GenericConverter(Camera camera, XMLMaker2.SALType salType) {
        this.salType = salType;
        this.camera = camera;
    }

    public boolean addSubsystem(String subsystemName) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(subsystemName);
        if (opt.isPresent()) {
            return this.addSubsystem(opt.get(), opt.get().getLevel());
        }
        return false;
    }

    public boolean addSubsystem(String subsystemName, int level) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(subsystemName);
        if (opt.isPresent()) {
            return this.addSubsystem(opt.get(), level);
        }
        return false;
    }

    public boolean addSubsystem(String subsystemName, DataProviderDictionary dict) {
        Optional<MakeXMLConfiguration.DictionaryConfiguration> opt = this.getDictionaryConfgurationForSubsystemName(subsystemName, dict);
        if (opt.isPresent()) {
            MakeXMLConfiguration.DictionaryConfiguration dictConfig = opt.get();
            return this.addSubsystem(dictConfig, dictConfig.getLevel());
        }
        return false;
    }

    private boolean addSubsystem(MakeXMLConfiguration.DictionaryConfiguration dictConfig, int level) {
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictConfig, this.mapping, level);
        this.salClassDescriptionMakerMap.put(dictConfig.getAgentName(), maker);
        this.subsystemsToConvert.add(dictConfig.getAgentName());
        this.componentNames.add(dictConfig.getComponentName());
        return true;
    }

    public void removeSubsystem(String subsystemName) {
        SALClassDescriptionMaker maker = this.salClassDescriptionMakerMap.remove(subsystemName);
        this.subsystemsToConvert.remove(subsystemName);
        if (maker != null) {
            this.componentNames.remove(maker.getDictionaryConfiguration().getComponentName());
        }
    }

    private Optional<MakeXMLConfiguration.DictionaryConfiguration> getDictionaryConfgurationForSubsystemName(String subsystemName, DataProviderDictionary dict) {
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)this.salType, (String)subsystemName, (DataProviderDictionary)dict).getDictionaryConfigurationForAgent(subsystemName);
        if (dictConfig != null) {
            return Optional.of(dictConfig);
        }
        return Optional.empty();
    }

    private Optional<MakeXMLConfiguration.DictionaryConfiguration> getDictionaryConfgurationForSubsystemName(String subsystemName) {
        MakeXMLConfiguration.DictionaryConfiguration dictConfig = MakeXMLConfiguration.getInstance((Camera)this.camera, (XMLMaker2.SALType)this.salType).getDictionaryConfigurationForAgent(subsystemName);
        if (dictConfig != null) {
            return Optional.of(dictConfig);
        }
        return Optional.empty();
    }

    public Map<String, Class> getClassMap() {
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        for (SALClassDescriptionMaker maker : this.salClassDescriptionMakerMap.values()) {
            classMap.putAll(maker.getSALClasses());
        }
        return classMap;
    }

    public Map<String, SALClassDescription> getSALClassDescriptionMapForAgent(String agentName) {
        return this.salClassDescriptionMakerMap.get(agentName).getSALClassDescriptions();
    }

    public List<CameraTelemetry> telemetryConverter(StatusSubsystemData data) throws ReflectiveOperationException {
        String subsystemName = data.getOriginAgentInfo().getName();
        KeyValueDataList subsystemData = data.getEncodedData();
        if (subsystemData == null) {
            return Collections.emptyList();
        }
        List values = (List)((Object)subsystemData.getValue());
        HashMap<String, Serializable> dataNamesAndValues = new HashMap<String, Serializable>();
        for (KeyValueData kvd : values) {
            String pathFromBus = kvd.getKey();
            if (pathFromBus.contains("/state")) continue;
            dataNamesAndValues.put(pathFromBus, kvd.getValue());
        }
        HashMap<String, Map<String, Object>> trendingData = new HashMap<String, Map<String, Object>>();
        try {
            if (subsystemData.getAttribute("taskName") == null) {
                trendingData.put("Trending", dataNamesAndValues);
            } else {
                trendingData.put("", dataNamesAndValues);
            }
        }
        catch (NullPointerException npe) {
            trendingData.put("", dataNamesAndValues);
        }
        return this.telemetryConverter(subsystemName, trendingData);
    }

    List<CameraTelemetry> telemetryConverter(String subsystemName, Map<String, Map<String, Object>> trendingData) throws ReflectiveOperationException {
        if (!this.salType.equals((Object)XMLMaker2.SALType.TELEMETRY)) {
            throw new RuntimeException("Cannot invoke telemetry conversion for type converter of type " + this.salType);
        }
        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<CameraTelemetry>();
        for (Map.Entry<String, Map<String, Object>> e : trendingData.entrySet()) {
            Map<String, Object> dataNamesAndValues = e.getValue();
            if (!this.subsystemsToConvert.contains(subsystemName)) {
                System.out.println("********************************************** ");
                System.out.println("Warning: returning Empty List of CameraTelemetry ");
                System.out.println("Current susbsystem = " + subsystemName);
                System.out.println("Contents of subsystemsToConvert :" + this.subsystemsToConvert.toString());
                System.out.println("********************************************** ");
                return Collections.emptyList();
            }
            Map givenSalClassMapInfo = this.salClassDescriptionMakerMap.get(subsystemName).getSALClassDescriptions();
            for (Map.Entry scd : givenSalClassMapInfo.entrySet()) {
                String scdSALClassName = (String)scd.getKey();
                if (!((SALClassDescription)scd.getValue()).getCategory().equals(e.getKey())) continue;
                Class realSALClass = ((SALClassDescription)scd.getValue()).getSimpleSalClass();
                if (realSALClass == null) {
                    // empty if block
                }
                if (realSALClass == null) continue;
                Parameter[] parameters = realSALClass.getConstructors()[0].getParameters();
                CameraTelemetry ct = (CameraTelemetry)this.reflectedClass(realSALClass, dataNamesAndValues, parameters, (SALClassDescription)scd.getValue(), null);
                int[] check = this.checkClassCompleteness(ct);
                int numMissingValues = check[0];
                int numGetMethods = check[1];
                int numberOfBooleanGets = check[2];
                boolean gets = false;
                boolean bools = false;
                gets = numMissingValues < numGetMethods;
                boolean bl = bools = numberOfBooleanGets > 0;
                if (!gets && (!bools || numGetMethods != 0)) continue;
                salTelemetry.add(ct);
            }
        }
        return salTelemetry;
    }

    public List<CameraEvent> settingsAppliedEventConverter(StatusConfigurationInfo sdata) throws ReflectiveOperationException {
        ConfigurationInfo data = sdata.getConfigurationInfo();
        List cpinfo = data.getAllParameterInfo();
        String subsystemName = sdata.getOriginAgentInfo().getName();
        if (!this.subsystemsToConvert.contains(subsystemName)) {
            System.out.println("********************************************** ");
            System.out.println("Warning: returning Empty List of CameraEvents ");
            System.out.println("Current susbsystem = " + sdata.getOriginAgentInfo().getName());
            System.out.println("Contents of subsystemsToConvert :" + this.subsystemsToConvert.toString());
            System.out.println("********************************************** ");
            return Collections.emptyList();
        }
        HashMap<String, Map<String, Object>> categoryDataMap = new HashMap<String, Map<String, Object>>();
        for (ConfigurationParameterInfo cpi : cpinfo) {
            String category = cpi.getCategoryName();
            Map dataMapForCategory = categoryDataMap.computeIfAbsent(category, c -> new HashMap());
            dataMapForCategory.put(cpi.getPathName(), cpi.getCurrentValueObject());
        }
        HashMap<String, String> catVersionMap = new HashMap<String, String>();
        for (String category : data.getCategorySet()) {
            catVersionMap.put(category, data.getConfigurationDescriptionObject().getCategoryTag(category).toString());
        }
        return this.settingsAppliedEventConverter(subsystemName, categoryDataMap, catVersionMap);
    }

    List<CameraEvent> settingsAppliedEventConverter(String subsystemName, Map<String, Map<String, Object>> categoryDataMap, Map<String, String> categoryVersionMap) throws ReflectiveOperationException {
        if (!this.salType.equals((Object)XMLMaker2.SALType.SETTINGS_APPLIED)) {
            throw new RuntimeException("Cannot invoke events conversion for type converter of type " + this.salType);
        }
        ArrayList<CameraEvent> salSettings = new ArrayList<CameraEvent>();
        Map salClassMapInfo = this.salClassDescriptionMakerMap.get(subsystemName).getSALClassDescriptions();
        for (Map.Entry sc : salClassMapInfo.entrySet()) {
            Class realSALClass;
            String scCategory = ((SALClassDescription)sc.getValue()).getCategory();
            Map<String, Object> thisCategoriesDataNew = categoryDataMap.get(scCategory);
            if (thisCategoriesDataNew == null) continue;
            String componentName = this.componentNames.get(this.subsystemsToConvert.indexOf(subsystemName));
            if (!((String)sc.getKey()).contains("_" + componentName + "_") || scCategory == null || scCategory == "null" || scCategory.isEmpty() || (realSALClass = ((SALClassDescription)sc.getValue()).getSimpleSalClass()) == null || thisCategoriesDataNew.isEmpty()) continue;
            Parameter[] parameters = realSALClass.getConstructors()[0].getParameters();
            String categoryVersion = categoryVersionMap.get(scCategory);
            try {
                CameraEvent ce = (CameraEvent)this.reflectedClass(realSALClass, thisCategoriesDataNew, parameters, (SALClassDescription)sc.getValue(), categoryVersion);
                int[] check = this.checkClassCompleteness(ce);
                int numMissingValues = check[0];
                int numGetMethods = check[1];
                int numberOfBooleanGets = check[2];
                if (numMissingValues != numGetMethods) {
                    salSettings.add(ce);
                }
                if (numMissingValues != numGetMethods) continue;
            }
            catch (ReflectiveOperationException | RuntimeException x) {
                LOG.log(Level.WARNING, "Error converting configuration, continuing", x);
            }
        }
        return salSettings;
    }

    private Object reflectedClass(Class cls, Map<String, Object> dataNamesAndValues, Parameter[] parameters, SALClassDescription salClassDescriptionList, String categoryVersion) throws ReflectiveOperationException {
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        HashMap<String, List> locationBusVariableCorrespondence = new HashMap<String, List>();
        HashMap<String, List> locationAvailableValuesMap = new HashMap<String, List>();
        for (Parameter[] sv : salClassDescriptionList.getVariables()) {
            if (!(sv instanceof SALClassDescription.PatternMatchedSALVariable)) continue;
            SALClassDescription.PatternMatchedSALVariable patternVar = (SALClassDescription.PatternMatchedSALVariable)sv;
            SALClassDescription.LocationVariable locationVar = patternVar.getLocationVariable();
            String locationName = locationVar.getVariableName();
            locationBusVariableCorrespondence.put(locationName, locationVar.getBusVariables());
            locationAvailableValuesMap.put(locationName, locationVar.getAvailableLocationValues());
        }
        boolean found = false;
        for (Parameter parameter : parameters) {
            found = false;
            if (parameter.getName().trim().equals("priority")) {
                constructorArgs.add(1);
                found = true;
            }
            if (parameter.getName().trim().equals("version")) {
                constructorArgs.add(categoryVersion);
                found = true;
            }
            if (!found) {
                for (SALClassDescription.SALVariable sv : salClassDescriptionList.getVariables()) {
                    Object returnedBusData;
                    int i;
                    String parameterType = parameter.getType().toString();
                    boolean parameterIsArray = parameter.getType().isArray();
                    boolean isAnArrayList = parameterType.contains("List") || parameterType.contains("List");
                    boolean isAnArray = !isAnArrayList && parameterType.contains("[");
                    boolean isAString = parameterType.contains("String") || parameterType.contains("String");
                    boolean isAMap = parameterType.contains("Map");
                    boolean involvesPatternMatching = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                    if (involvesPatternMatching) {
                        // empty if block
                    }
                    boolean matchParName = sv.getVariableName().toLowerCase().trim().equals(parameter.getName().toLowerCase().trim());
                    String svVariableName = "";
                    boolean isLocation = false;
                    if (sv instanceof SALClassDescription.LocationVariable) {
                        svVariableName = ((SALClassDescription.LocationVariable)sv).getVariableName();
                        isLocation = true;
                    } else if (sv instanceof SALClassDescription.PatternMatchedSALVariable) {
                        svVariableName = ((SALClassDescription.PatternMatchedSALVariable)sv).getLocationVariable().getVariableName();
                    }
                    if (!matchParName) continue;
                    if (parameterIsArray && involvesPatternMatching && !isLocation) {
                        List locationVals = (List)locationAvailableValuesMap.get(svVariableName);
                        Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), locationVals.size());
                        for (SALClassDescription.BusVariable busVar : ((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables()) {
                            String pathName = busVar.getPathAndNameOnBuses();
                            String busVarLocation = busVar.getLocationValue();
                            i = locationVals.indexOf(busVarLocation);
                            Object returnedBusData2 = this.returnBusData(cls, parameter, pathName, dataNamesAndValues.get(pathName));
                            if (null != returnedBusData2) {
                                Object returnedData = returnedBusData2;
                                if (returnedData.getClass().isArray()) {
                                    arrayArg = returnedData;
                                    continue;
                                }
                                Array.set(arrayArg, i, returnedData);
                                continue;
                            }
                            Array.set(arrayArg, i, this.AssignValuesForMissingBusData(parameter));
                        }
                        constructorArgs.add(arrayArg);
                        found = true;
                    }
                    if (!parameterIsArray && sv instanceof SALClassDescription.LocationVariable) {
                        if (locationBusVariableCorrespondence.get(sv.getVariableName()) == null) {
                            // empty if block
                        }
                        constructorArgs.add(GenericConverter.convertStringList(((SALClassDescription.LocationVariable)sv).getAvailableLocationValues()));
                        found = true;
                    }
                    if (parameterIsArray && !involvesPatternMatching) {
                        boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                        String busVariableName = ((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses();
                        returnedBusData = this.returnBusData(cls, parameter, busVariableName, dataNamesAndValues.get(busVariableName));
                        if (null != returnedBusData) {
                            int xmlArraySize = ((SALClassDescription.SimpleSALVariable)sv).getCount();
                            Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), xmlArraySize);
                            int dataArraySize = Array.getLength(returnedBusData);
                            if (dataArraySize > xmlArraySize) {
                                LOG.log(Level.WARNING, "Array for variable {0} exceeds the specified xml size (MaxLength = {1}, actual size = {2}). Excess data is lost.", new Object[]{busVariableName, xmlArraySize, dataArraySize});
                            }
                            for (i = 0; i < dataArraySize; ++i) {
                                Array.set(arrayArg, i, Array.get(returnedBusData, i));
                            }
                            for (i = dataArraySize; i < xmlArraySize; ++i) {
                                Array.set(arrayArg, i, this.AssignValuesForMissingBusData(parameter));
                            }
                            constructorArgs.add(arrayArg);
                        } else {
                            Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), new int[0]);
                            Array.set(arrayArg, 0, this.AssignValuesForMissingBusData(parameter));
                            constructorArgs.add(arrayArg);
                        }
                        found = true;
                    }
                    if (involvesPatternMatching && !parameterIsArray && !isLocation) {
                        boolean matched = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                        SALClassDescription.PatternMatchedSALVariable pmv = (SALClassDescription.PatternMatchedSALVariable)sv;
                        if (parameter.getType() != String.class) {
                            throw new RuntimeException("What should we do with type: " + parameter.getType() + " for parameter " + parameter.getName());
                        }
                        String result = "";
                        for (SALClassDescription.BusVariable bv : pmv.getBusVariables()) {
                            String pathName = bv.getPathAndNameOnBuses();
                            String returnedBusData3 = (String)this.returnBusData(cls, parameter, pathName, dataNamesAndValues.get(pathName));
                            if (!result.isEmpty()) {
                                result = result + ":";
                            }
                            result = result + returnedBusData3;
                        }
                        constructorArgs.add(result);
                        found = true;
                    }
                    if (involvesPatternMatching || parameterIsArray || isLocation) continue;
                    boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                    String pathName = ((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses();
                    returnedBusData = this.returnBusData(cls, parameter, pathName, dataNamesAndValues.get(pathName));
                    if (null != returnedBusData) {
                        constructorArgs.add(returnedBusData);
                    } else {
                        constructorArgs.add(this.AssignValuesForMissingBusData(parameter));
                    }
                    found = true;
                }
            }
            if (found) continue;
            this.mia.add(parameter.getName());
            this.alreadyWarned.put(cls, this.mia);
            int jj = Collections.frequency((Collection)this.alreadyWarned.get(cls), parameter.getName());
            if (parameter.getType().isArray()) {
                Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), 0);
                constructorArgs.add(arrayArg);
                continue;
            }
            constructorArgs.add(this.AssignValuesForMissingBusData(parameter));
        }
        try {
            return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
        }
        catch (ReflectiveOperationException | RuntimeException x) {
            throw new RuntimeException(String.format("Error creating SAL event for class %s with args %s", cls.getCanonicalName(), GenericConverter.betterToString(parameters, constructorArgs)), x);
        }
    }

    private Object returnBusData(Class cls, Parameter parameter, String pathName, Object returnValue) {
        boolean classTypeIsConfig = false;
        if (cls.getCanonicalName().contains("Event") && cls.getCanonicalName().contains("org.lsst.sal.cccamera.event")) {
            classTypeIsConfig = true;
        }
        if (returnValue == null) {
            return null;
        }
        if (returnValue instanceof Double) {
            // empty if block
        }
        if (returnValue instanceof Duration && !parameter.getType().toString().toLowerCase().contains("string")) {
            returnValue = ((Duration)returnValue).getSeconds();
        }
        if (returnValue instanceof HashMap) {
            returnValue = ((HashMap)returnValue).toString();
        }
        if (returnValue.getClass().getTypeName().toLowerCase().contains("string") && returnValue instanceof String[]) {
            returnValue = GenericConverter.convertStringArray((String[])returnValue);
        }
        if (returnValue instanceof List || returnValue instanceof Map || returnValue instanceof Enum) {
            returnValue = returnValue.toString();
        }
        if (returnValue instanceof Duration && parameter.getType().toString().toLowerCase().contains("string")) {
            returnValue = returnValue.toString();
        }
        if (returnValue.getClass().getTypeName().toLowerCase().contains("string") && returnValue instanceof List) {
            returnValue = GenericConverter.convertStringList((List)returnValue);
        }
        if (null == returnValue) {
            if (classTypeIsConfig) {
                System.out.println(" ====================================================================");
                System.out.println(" Warning ! Bus data contains null for pathname : " + pathName);
                System.out.println(" this corresponds to class name  " + cls.getTypeName() + ", parameter name " + parameter.getName());
                System.out.println(" ====================================================================");
            }
            returnValue = this.AssignValuesForMissingBusData(parameter);
        }
        return returnValue;
    }

    private boolean badValueOrValues(Object invokedValue, Object badValue, String className, String methodName) {
        boolean bad = true;
        boolean isanArray = invokedValue.getClass().isArray();
        String type = invokedValue.getClass().getTypeName();
        boolean isDouble = false;
        boolean isString = false;
        boolean isInt = false;
        boolean isFloat = false;
        boolean isLong = false;
        boolean isBool = false;
        boolean isShort = false;
        if (type.toLowerCase().contains("double")) {
            isDouble = true;
            badValue = this.badDValue;
            if (isanArray && isDouble) {
                double[] doubleArray = (double[])invokedValue;
                for (int i = 0; i < doubleArray.length; ++i) {
                    if (Double.isNaN(doubleArray[i])) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("string")) {
            isString = true;
            badValue = this.badStringValue;
            if (isanArray) {
                String[] stringArray = (String[])invokedValue;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == this.badStringValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("int")) {
            isInt = true;
            badValue = this.badIValue;
            if (isanArray) {
                int[] intArray = (int[])invokedValue;
                for (int i = 0; i < intArray.length; ++i) {
                    if (intArray[i] == (Integer)badValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("float")) {
            isFloat = true;
            badValue = Float.valueOf(this.badFValue);
            if (isanArray) {
                float[] floatArray = (float[])invokedValue;
                for (int i = 0; i < floatArray.length; ++i) {
                    if (Float.isNaN(floatArray[i])) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("long")) {
            isLong = true;
            badValue = this.badLValue;
            if (isanArray) {
                long[] longArray = (long[])invokedValue;
                for (int i = 0; i < longArray.length; ++i) {
                    if (longArray[i] == this.badLValue) continue;
                    bad = false;
                }
            }
        } else if (type.toLowerCase().contains("short")) {
            isShort = true;
            badValue = this.badSValue;
            if (isanArray) {
                short[] shortArray = (short[])invokedValue;
                for (int i = 0; i < shortArray.length; ++i) {
                    if ((long)shortArray[i] == (long)this.badSValue) continue;
                    bad = false;
                }
            }
        } else {
            throw new RuntimeException("Value provided is not in the list of expected values : " + type);
        }
        if (!isanArray && !invokedValue.equals(badValue)) {
            bad = false;
        }
        return bad;
    }

    private static String betterToString(Parameter[] parameters, ArrayList<Object> data) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            boolean classesMatch = ClassUtils.isAssignable(data.get(i).getClass(), parameters[i].getType(), true);
            String argString = parameters[i].getName() + "=" + (data.get(i).getClass().isArray() ? GenericConverter.arrayToString(data.get(i)) : data.get(i).toString());
            if (!classesMatch) {
                argString = argString + String.format(" WARNING: classMismatch %s != %s", parameters[i].getType(), data.get(i).getClass());
            }
            result.add(argString);
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private static String convertStringSet(Set<String> stringSet) {
        String[] localArray = new String[stringSet.size()];
        stringSet.toArray(localArray);
        return GenericConverter.manipulateStringArray(localArray);
    }

    private static String convertStringList(List<String> stringList) {
        String[] localArray = new String[stringList.size()];
        stringList.toArray(localArray);
        return GenericConverter.manipulateStringArray(localArray);
    }

    private static String convertStringArray(String[] stringArray) {
        Object localArray = null;
        return GenericConverter.manipulateStringArray(stringArray);
    }

    private static String manipulateStringArray(String[] inputArray) {
        String returnStringI = "";
        String returnStringF = "";
        int lengthOfStringArray = inputArray.length;
        if (lengthOfStringArray <= 0) {
            System.out.println("Warning from GenericConverter3:manipulateStringArray : Length of string Array is 0 !");
            returnStringF = "NOTFOUND";
        } else {
            for (int i = 0; i < lengthOfStringArray; ++i) {
                returnStringI = returnStringI + inputArray[i] + ":";
                if (i != lengthOfStringArray - 1) continue;
                int target = returnStringI.lastIndexOf(":");
                returnStringF = target == -1 ? returnStringI : returnStringI.substring(0, target);
            }
        }
        return returnStringF;
    }

    private static String arrayToString(Object array) {
        ArrayList<String> result = new ArrayList<String>();
        int l = Array.getLength(array);
        for (int i = 0; i < l; ++i) {
            result.add(Array.get(array, i).toString());
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private int[] checkClassCompleteness(Object cls) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Parameter[] thisClassParameters = cls.getClass().getConstructors()[0].getParameters();
        Method[] methods = cls.getClass().getDeclaredMethods();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        int numMissingValues = 0;
        int numGetMethods = 0;
        int[] returnValues = new int[3];
        int countBooleanFunctions = 0;
        for (int i = 0; i < methods.length; ++i) {
            String[] parts;
            String methodName = methods[i].getName();
            Method method = null;
            method = cls.getClass().getDeclaredMethod(methodName, new Class[0]);
            String methodS = method.toString();
            if (methodS.toLowerCase().contains("boolean")) {
                ++countBooleanFunctions;
            }
            if ((parts = methodName.split("\\s"))[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
            getMethods.add(methods[i]);
            ++numGetMethods;
        }
        boolean checkbadvalue = false;
        for (Method method : getMethods) {
            if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("double")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badDValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("string")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badStringValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("float")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), Float.valueOf(this.badFValue), cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("int")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badIValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("long")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badLValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("short")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badSValue, cls.getClass().getName(), method.getName());
            }
            if (checkbadvalue) {
                ++numMissingValues;
            }
            if (checkbadvalue || !method.getName().toLowerCase().equals("getlocation")) continue;
            ++numMissingValues;
        }
        returnValues[0] = numMissingValues;
        returnValues[1] = numGetMethods;
        returnValues[2] = countBooleanFunctions;
        return returnValues;
    }

    private Map<String, ConfigurationParameterInfo> alternateCategoryData(ConfigurationInfo data, String category) {
        HashMap<String, ConfigurationParameterInfo> returnMap = new HashMap();
        System.out.println(" AlternateCategoryData requested for category " + category);
        try {
            returnMap = data.getCurrentParameterInfoForCategory(category);
        }
        catch (NullPointerException e) {
            System.out.println(" Null pointer exception caught " + e.toString() + " for category " + category);
        }
        return returnMap;
    }

    private Object AssignValuesForMissingBusData(Parameter parameter) {
        Object badValue = null;
        String type = parameter.getParameterizedType().getTypeName().toLowerCase();
        if (type.contains("float")) {
            badValue = Float.valueOf(this.badFValue);
        }
        if (type.contains("int")) {
            badValue = this.badIValue;
        }
        if (type.contains("long")) {
            badValue = this.badLValue;
        }
        if (type.contains("boolean")) {
            badValue = this.badBValue;
        }
        if (type.contains("double")) {
            badValue = this.badDValue;
        }
        if (type.contains("short")) {
            badValue = this.badSValue;
        }
        if (type.contains("string")) {
            badValue = this.badStringValue;
        }
        return badValue;
    }
}

