import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.vacuum.VacuumMain
import org.lsst.ccs.subsystem.vacuum.VacPlutoDevice
import org.lsst.ccs.subsystem.vacuum.VacSimPlutoDevice
import org.lsst.ccs.subsystem.vacuum.VacPduDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpDevice
import org.lsst.ccs.subsystem.vacuum.IonPumpControl
import org.lsst.ccs.subsystem.vacuum.VacTurboDevice
import org.lsst.ccs.subsystem.vacuum.VacMksDevice
import org.lsst.ccs.subsystem.vacuum.VacSimMksDevice
import org.lsst.ccs.subsystem.vacuum.SimMaq20Device
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.common.alertaction.MpmActionClient
import org.lsst.ccs.subsystem.vacuum.constants.Devices
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Alarm
import org.lsst.ccs.monitor.CalcChannel
import org.lsst.ccs.monitor.CalcChannel.Operation


Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    vacMksDevice = VacSimMksDevice
    vacPlutoDevc = VacSimPlutoDevice
    maq20Device = SimMaq20Device
}
else {
    vacMksDevice = VacMksDevice
    vacPlutoDevc = VacPlutoDevice
    maq20Device = Maq20Device
} 

CCSBuilder builder = ["vacuum"]

builder.main (VacuumMain, cryoVacPressure:ref("Cryo/CryoVac"), cryoTurboPressure:ref("Cryo/TurboVac"),
              cryoTurboSpeed:ref("Cryo/TurboSpeed"), cryoTurboTemp:ref("Cryo/TurboPumpTemp"),
              cryoTurboPower:ref("Cryo/TurboPower"), cryoFlinePressure:ref("Cryo/ForelineVac"),
              hxVacPressure:ref("HX/HexVac"), hxTurboPressure:ref("HX/TurboVac"),
              hxTurboSpeed:ref("HX/TurboSpeed"), hxTurboTemp:ref("HX/TurboPumpTemp"),
              hxTurboPower:ref("HX/TurboPower"), hxFlinePressure:ref("HX/ForelineVac"),
              airPressure:ref("Cryo/AirPressure")) {

    ActionClient (MpmActionClient)

    TurboPowerHigh (Alarm, description:"Turbo Power High")

    TurboTempHigh (Alarm, description:"Turbo Temperature High")

    AirPressBad (Alarm, description:"Air Pressure Incorrect")

    VacPluto (vacPlutoDevc)

    int cip1 = IonPumpDevice.CHAN_CIP1
    int cip2 = IonPumpDevice.CHAN_CIP2
    int cip3 = IonPumpDevice.CHAN_CIP3
    int cip4 = IonPumpDevice.CHAN_CIP4
    int cip5 = IonPumpDevice.CHAN_CIP5
    int cip6 = IonPumpDevice.CHAN_CIP6
    int hip1 = IonPumpDevice.CHAN_HIP1
    int hip2 = IonPumpDevice.CHAN_HIP2

    IonPumps (IonPumpDevice) {

        CIP1C (IonPumpControl, hwChan:cip1)

        CIP2C (IonPumpControl, hwChan:cip2)

        CIP3C (IonPumpControl, hwChan:cip3)

        CIP4C (IonPumpControl, hwChan:cip4)

        CIP5C (IonPumpControl, hwChan:cip5)

        CIP6C (IonPumpControl, hwChan:cip6)

        HIP1C (IonPumpControl, hwChan:hip1)

        HIP2C (IonPumpControl, hwChan:hip2)

    }

    CryoTurboPump (VacTurboDevice, deviceId: Devices.DEVC_CRYO_TURBO_PUMP)

    // CryoVacGauge (mks9xxDevice)
    CryoVacGauge (vacMksDevice, deviceId: Devices.DEVC_CRYO_VAC_MKS)

    // CryoTurboGauge (mks9xxDevice)
    CryoTurboGauge (vacMksDevice, deviceId: Devices.DEVC_CRYO_TURBO_MKS)

    CryoFlineGauge (vacMksDevice, deviceId: Devices.DEVC_NO_SWITCH)

    HexTurboPump (VacTurboDevice, deviceId: Devices.DEVC_HX_TURBO_PUMP)

    // HexVacGauge (mks9xxDevice)
    HexVacGauge (vacMksDevice, deviceId: Devices.DEVC_HX_VAC_MKS)

    //HexTurboGauge (mks9xxDevice)
    HexTurboGauge (vacMksDevice, deviceId: Devices.DEVC_HX_TURBO_MKS)

    HexFlineGauge (vacMksDevice, deviceId: Devices.DEVC_NO_SWITCH)

    InstVacGauge (vacMksDevice, deviceId: Devices.DEVC_NO_SWITCH)

    PDU (VacPduDevice)

    Maq20 (maq20Device, modules:["IS"])

    "Cryo/CryoVac" (Channel, description:"Cryostat vacuum", units:"Torr", format:".3g",
                    devcName:"CryoVacGauge")

    "Cryo/TurboVac" (Channel, description:"Turbo pump vacuum", units:"Torr", format:".3g",
                     devcName:"CryoTurboGauge")

    "Cryo/ForelineVac" (Channel, description:"Foreline pump vacuum", units:"Torr", format:".3g",
                        devcName:"CryoFlineGauge")

    "Cryo/TurboSpeed"    (Channel, description:"Cryo turbo pump speed", units:"rpm", format:".0f",
                          devcName:"CryoTurboPump", type:"Numeric", subtype:"DRIVEFREQ", scale:60)

    "Cryo/TurboCurrent"  (Channel, description:"Cryo turbo pump current", units:"mA dc", format:"%.0f",
                          devcName:"CryoTurboPump", type:"Numeric", subtype:"CURRENT",
                          checkLo:"none", checkHi:"none")

    "Cryo/TurboVoltage"  (Channel, description:"Cryo turbo pump voltage", units:"V dc", format:"%.0f",
                          devcName:"CryoTurboPump", type:"Numeric", subtype:"VOLTAGE",
                          checkLo:"none", checkHi:"none")

    "Cryo/TurboPower"    (Channel, description:"Cryo turbo pump power", units:"W", format:"%.0f",
                          devcName:"CryoTurboPump", type:"Numeric", subtype:"POWER",
                          checkLo:"none", checkHi:"alarm", alarmHi:"TurboPowerHigh")

    "Cryo/TurboPumpTemp" (Channel, description:"Cryo turbo pump temperature", units:"deg C", format:"%.0f",
                          devcName:"CryoTurboPump", type:"Numeric", subtype:"PUMP_TEMP",
                          checkLo:"flag", checkHi:"alarm", alarmHi:"TurboTempHigh")

    "Cryo/FlineVoltage"  (Channel, description:"Cryo foreline pump voltage", units:"Volts", format:"%.1f",
                          devcName:"PDU", hwChan:VacPduDevice.CHAN_CRYO_SCROLL, type:"VOLTAGE",
                          checkLo:"none", checkHi:"none")

    "Cryo/FlineCurrent"  (Channel, description:"Cryo foreline pump current", units:"mA", format:"%.1f",
                          devcName:"PDU", hwChan:VacPduDevice.CHAN_CRYO_SCROLL, type:"CURRENT", scale:1000.0,
                          checkLo:"none", checkHi:"none")

    "Cryo/FlinePower" (CalcChannel, description:"Cryo foreline pump power", units:"Watts", format:"%.1f",
                       devcName:"PDU", type:Operation.PROD, channelPaths:["Cryo/FlineVoltage","Cryo/FlineCurrent"], scale:0.001, 
                       checkLo:"none")

    "Cryo/AirPressure" (Channel, description:"UT compressed air pressure", units:"psig",
                        devcName:"Maq20", hwChan:6, type: "0", subtype: "MA4_20", scale:9375.0, offset:-52.2, // -37.5 - 14.7)
                        checkLo:"alarm", alarmLo:"AirPressBad", checkHi:"alarm", alarmHi:"AirPressBad")

    "Cryo/CIP1_V"     (Channel, description:"Cryo ion pump 1 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip1, type:"VOLTAGE")

    "Cryo/CIP1_I"     (Channel, description:"Cryo ion pump 1 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip1, type:"CURRENT", scale:1000.0)

    "Cryo/CIP1_Usage" (Channel, description:"Cryo ion pump 1 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip1, type:"USAGE")

    "Cryo/CIP1_Life"  (Channel, description:"Cryo ion pump 1 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip1, type:"LIFETIME")

    "Cryo/CIP2_V"     (Channel, description:"Cryo ion pump 2 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip2, type:"VOLTAGE")

    "Cryo/CIP2_I"     (Channel, description:"Cryo ion pump 2 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip2, type:"CURRENT", scale:1000.0)

    "Cryo/CIP2_Usage" (Channel, description:"Cryo ion pump 2 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip2, type:"USAGE")

    "Cryo/CIP2_Life"  (Channel, description:"Cryo ion pump 2 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip2, type:"LIFETIME")

    "Cryo/CIP3_V"     (Channel, description:"Cryo ion pump 3 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip3, type:"VOLTAGE")

    "Cryo/CIP3_I"     (Channel, description:"Cryo ion pump 3 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip3, type:"CURRENT", scale:1000.0)

    "Cryo/CIP3_Usage" (Channel, description:"Cryo ion pump 3 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip3, type:"USAGE")

    "Cryo/CIP3_Life"  (Channel, description:"Cryo ion pump 3 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip3, type:"LIFETIME")

    "Cryo/CIP4_V"     (Channel, description:"Cryo ion pump 4 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip4, type:"VOLTAGE")

    "Cryo/CIP4_I"     (Channel, description:"Cryo ion pump 4 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip4, type:"CURRENT", scale:1000.0)

    "Cryo/CIP4_Usage" (Channel, description:"Cryo ion pump 4 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip4, type:"USAGE")

    "Cryo/CIP4_Life"  (Channel, description:"Cryo ion pump 4 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip4, type:"LIFETIME")

    "Cryo/CIP5_V"     (Channel, description:"Cryo ion pump 5 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip5, type:"VOLTAGE")

    "Cryo/CIP5_I"     (Channel, description:"Cryo ion pump 5 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip5, type:"CURRENT", scale:1000.0)

    "Cryo/CIP5_Usage" (Channel, description:"Cryo ion pump 5 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip5, type:"USAGE")

    "Cryo/CIP5_Life"  (Channel, description:"Cryo ion pump 5 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip5, type:"LIFETIME")

    "Cryo/CIP6_V"     (Channel, description:"Cryo ion pump 6 voltage", units:"Volts", format:".1f",
                       devcName:"IonPumps", hwChan:cip6, type:"VOLTAGE")

    "Cryo/CIP6_I"     (Channel, description:"Cryo ion pump 6 current", units:"mA",
                       devcName:"IonPumps", hwChan:cip6, type:"CURRENT", scale:1000.0)

    "Cryo/CIP6_Usage" (Channel, description:"Cryo ion pump 6 usage", units:"Torr-hrs", format:".3g",
                       devcName:"IonPumps", hwChan:cip6, type:"USAGE")

    "Cryo/CIP6_Life"  (Channel, description:"Cryo ion pump 6 lifetime", units:"Hours", format:".0f",
                       devcName:"IonPumps", hwChan:cip6, type:"LIFETIME")

    "HX/HexVac" (Channel, description:"Heat exchanger vacuum", units:"Torr", format:".3g",
                 devcName:"HexVacGauge")

    "HX/TurboVac" (Channel, description:"HX turbo pump vacuum", units:"Torr", format:".3g",
                   devcName:"HexTurboGauge")

    "HX/ForelineVac" (Channel, description:"HX foreline pump vacuum", units:"Torr", format:".3g",
                      devcName:"HexFlineGauge")

    "HX/TurboSpeed"    (Channel, description:"HX turbo pump speed", units:"rpm", format:".0f",
                        devcName:"HexTurboPump", type:"Numeric", subtype:"DRIVEFREQ", scale:60)

    "HX/TurboCurrent"  (Channel, description:"HX turbo pump current", units:"mA dc", format:"%.0f",
                        devcName:"HexTurboPump", type:"Numeric", subtype:"CURRENT",
                        checkLo:"none", checkHi:"none")

    "HX/TurboVoltage"  (Channel, description:"HX turbo pump voltage", units:"V dc",  format:"%.0f",
                        devcName:"HexTurboPump", type:"Numeric", subtype:"VOLTAGE",
                        checkLo:"none", checkHi:"none")

    "HX/TurboPower"    (Channel, description:"HX turbo pump power", units:"W", format:"%.0f",
                        devcName:"HexTurboPump", type:"Numeric", subtype:"POWER",
                        checkLo:"none", checkHi:"alarm", alarmHi:"TurboPowerHigh")

    "HX/TurboPumpTemp" (Channel, description:"HX turbo pump temperature", units:"deg C", format:"%.0f",
                        devcName:"HexTurboPump", type:"Numeric", subtype:"PUMP_TEMP",
                        checkLo:"flag", checkHi:"alarm", alarmHi:"TurboTempHigh")

    "HX/FlineVoltage"  (Channel, description:"HX foreline pump voltage", units:"Volts", format:"%.1f",
                        devcName:"PDU", hwChan:VacPduDevice.CHAN_HEX_SCROLL, type:"VOLTAGE",
                        checkLo:"none", checkHi:"none")

    "HX/FlineCurrent"  (Channel, description:"HX foreline pump current", units:"mA", format:"%.1f",
                        devcName:"PDU", hwChan:VacPduDevice.CHAN_HEX_SCROLL, type:"CURRENT", scale:1000.0,
                        checkLo:"none", checkHi:"none")

    "HX/FlinePower" (CalcChannel, description:"HX foreline pump power", units:"Watts", format:"%.1f",
                     devcName:"PDU", type:Operation.PROD, channelPaths:["HX/FlineVoltage","HX/FlineCurrent"], scale:0.001, 
                     checkLo:"none")
                 
    "HX/AirPressure" (Channel, description:"UT compressed air pressure", units:"psig",
                      devcName:"Maq20", hwChan:6, type: "0", subtype: "MA4_20", scale:9375.0, offset:-52.2,  // -37.5 - 14.7)
                      checkLo:"alarm", alarmLo:"AirPressBad", checkHi:"alarm", alarmHi:"AirPressBad")

    "HX/HIP1_V"     (Channel, description:"HX ion pump 1 voltage", units:"Volts", format:".1f",
                     devcName:"IonPumps", hwChan:hip1, type:"VOLTAGE")

    "HX/HIP1_I"     (Channel, description:"HX ion pump 1 current", units:"mA",
                     devcName:"IonPumps", hwChan:hip1, type:"CURRENT", scale:1000.0)

    "HX/HIP1_Usage" (Channel, description:"HX ion pump 1 usage", units:"Torr-hrs", format:".3g",
                     devcName:"IonPumps", hwChan:hip1, type:"USAGE")

    "HX/HIP1_Life"  (Channel, description:"HX ion pump 1 lifetime", units:"Hours", format:".0f",
                     devcName:"IonPumps", hwChan:hip1, type:"LIFETIME")

    "HX/HIP2_V"     (Channel, description:"HX ion pump 2 voltage", units:"Volts", format:".1f",
                     devcName:"IonPumps", hwChan:hip2, type:"VOLTAGE")

    "HX/HIP2_I"     (Channel, description:"HX ion pump 2 current", units:"mA",
                     devcName:"IonPumps", hwChan:hip2, type:"CURRENT", scale:1000.0)

    "HX/HIP2_Usage" (Channel, description:"HX ion pump 2 usage", units:"Torr-hrs", format:".3g",
                     devcName:"IonPumps", hwChan:hip2, type:"USAGE")

    "HX/HIP2_Life"  (Channel, description:"HX ion pump 2 lifetime", units:"Hours", format:".0f",
                     devcName:"IonPumps", hwChan:hip2, type:"LIFETIME")

    "Inst/InstVac" (Channel, description:"Interstitial vacuum", units:"Torr", format:".3g",
                    devcName:"InstVacGauge")

    "Inst/FlineVoltage" (Channel, description:"Inst foreline pump voltage", units:"Volts", format:"%.1f",
                         devcName:"PDU", hwChan:VacPduDevice.CHAN_INST_SCROLL, type:"VOLTAGE",
                         checkLo:"none", checkHi:"none")

    "Inst/FlineCurrent" (Channel, description:"Inst foreline pump current", units:"mA", format:"%.1f",
                         devcName:"PDU", hwChan:VacPduDevice.CHAN_INST_SCROLL, type:"CURRENT", scale:1000.0,
                         checkLo:"none", checkHi:"none")

    "Inst/FlinePower" (CalcChannel, description:"Inst foreline pump power", units:"Watts", format:"%.1f",
                       devcName:"PDU", type:Operation.PROD, channelPaths:["Inst/FlineVoltage","Inst/FlineCurrent"], scale:0.001, 
                       checkLo:"none")
                   
}
