/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class SimMaq20Device
extends Maq20Device {
    private static final Logger LOG = Logger.getLogger(SimMaq20Device.class.getName());
    private final Map<String, Integer> channelMap = new LinkedHashMap<String, Integer>();
    private final List<Double> channelValues = new ArrayList<Double>();
    private final List<Double> channelScales = new ArrayList<Double>();
    private final List<Double> channelOffsets = new ArrayList<Double>();

    protected void initialize() {
        LOG.log(Level.INFO, "Connected to {0} (simulated MAQ20)", this.path);
        this.setOnline(true);
    }

    protected void close() {
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int index = this.channelValues.size();
        this.channelMap.put(ch.getName(), index);
        this.channelValues.add(Double.valueOf(index));
        double offset = ch.convertRawValue(0.0);
        double scale = ch.convertRawValue(1.0) - offset;
        this.channelOffsets.add(offset);
        this.channelScales.add(scale);
        return new int[]{index, 0};
    }

    protected double readChannel(Channel ch) {
        int type = ch.getType();
        return (this.channelValues.get(type) - this.channelOffsets.get(type)) / this.channelScales.get(type);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chan, @Argument(description="Channel value") double value) throws VacuumException {
        Integer index = this.channelMap.get(chan);
        if (index == null) {
            throw new VacuumException("Invalid channel name");
        }
        this.channelValues.set(index, value);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

