/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.main;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.OptionHandlerRegistry;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.lsst.ccs.visualization.server.CacheManager;
import org.lsst.ccs.visualization.server.VisualizationIngestServer;
import org.lsst.ccs.web.visualization.rest.Image;
import org.lsst.ccs.web.visualization.rest.ImageQueue;
import org.lsst.ccs.web.visualization.rest.RestServer;

public class Main {
    private final VisualizationIngestServer defaultServer = new VisualizationIngestServer(9999, new File("."));
    @Option(name="-ingestPort", usage="Set the port used by the visualization ingest server")
    private int ingestPort = 9999;
    @Option(name="-restPort", usage="Set the port used by the visualization restful interface")
    private int restPort = 8888;
    @Option(name="-dir", usage="The directory where received files will be stored. Recommended to be a ramdisk. WARNING system will manage this directory and its descendants and may delete files without notice.", required=true)
    private File receiveDirectory;
    @Option(name="-startTimeout", usage="The time after a start command that an idle connection will timeout")
    private Duration startTimeout = this.defaultServer.getStartTimeout();
    @Option(name="-idleTimeout", usage="Time since last message that an idle connection is considered to have timed out")
    private Duration activeTimeout = this.defaultServer.getActiveTimeout();
    @Option(name="-startWait", usage="The time we will wait for a start message after some other message has been received")
    private Duration startWait = this.defaultServer.getStartWait();
    @Option(name="-freeCacheSize", usage="The minimum free space to maintain in the cache")
    private long freeCacheTarget = 0x40000000L;

    public static void main(String[] args) throws IOException {
        OptionHandlerRegistry.getRegistry().registerHandler(Duration.class, DurationOptionHandler.class);
        Main main = new Main();
        CmdLineParser parser = new CmdLineParser((Object)main);
        try {
            parser.parseArgument(args);
            main.run();
        }
        catch (CmdLineException x) {
            System.err.println(x.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }

    private void run() throws IOException {
        try (CacheManager cacheManager = new CacheManager(this.receiveDirectory, this.freeCacheTarget);){
            cacheManager.start(Duration.ofMinutes(1L));
            ImageQueue imageQueue = new ImageQueue();
            RestServer restServer = new RestServer();
            URI baseURI = URI.create("http://localhost:" + this.restPort + "/vis/");
            restServer.start(imageQueue, baseURI);
            VisualizationIngestServer server = new VisualizationIngestServer(this.ingestPort, this.receiveDirectory);
            server.setStartWait(this.startWait);
            server.setActiveTimeout(this.activeTimeout);
            server.setStartTimeout(this.startTimeout);
            server.addImageListener((name, timeStamp, file) -> {
                imageQueue.put(new Image(file.toURI(), name, timeStamp));
                cacheManager.scanNow();
            });
            server.run();
        }
    }

    public static class DurationOptionHandler
    extends OptionHandler<Duration> {
        public DurationOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Duration> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters prmtrs) throws CmdLineException {
            Duration.parse(prmtrs.getParameter(0));
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "duration";
        }
    }
}

