/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.BfrComCam;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.utilities.logging.Logger;

public class BfrComCamDevice
extends Device
implements SwitchControl {
    private static final Logger LOG = Logger.getLogger((String)BfrComCamDevice.class.getName());
    private static final String NODE = "node";
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true)
    private volatile Integer node;
    private final BfrComCam bfr = new BfrComCam();
    private double[] currents = null;

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "BFR board (" + this.node + ")";
    }

    public void initialize() {
        try {
            this.bfr.open(this.node.intValue());
            this.initSensors();
            LOG.info((Object)("Connected to " + this.fullName));
            this.setOnline(true);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.bfr.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 11) {
            MonitorLogUtils.reportError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{0, 0};
    }

    protected String getGroupForChannel(Channel ch) {
        return "currents";
    }

    protected void readChannelGroup(String group) {
        this.currents = null;
        if (this.isOnline()) {
            try {
                this.currents = this.bfr.readCurrent(BfrComCam.CurrentType.AC);
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading " + this.fullName + " currents: " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
    }

    protected double readChannel(Channel ch) {
        int hwChan = ch.getHwChan();
        return this.currents == null ? Double.NaN : this.currents[hwChan];
    }

    @Override
    public int getSwitchDevice() {
        return 0;
    }

    @Override
    public void switchOn(int relay) {
        try {
            this.bfr.setRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error setting relay " + relay + " on " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    @Override
    public void switchOff(int relay) {
        try {
            this.bfr.setRelayOff(relay);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error setting relay " + relay + " on " + this.fullName + ": " + (Object)((Object)e)));
        }
    }

    @Override
    public Boolean isSwitchOn(int relay) {
        if (!this.isOnline() || relay < 0) {
            return null;
        }
        try {
            return this.bfr.isRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.error((Object)("Error getting state for relay " + relay + " on " + this.fullName + ": " + (Object)((Object)e)));
            return null;
        }
    }
}

