/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;

public class MoveAxisRelativePLC
extends MsgToPLC {
    private final MoveAxisRelative msg;

    public MoveAxisRelativePLC(MoveAxisRelative msg) {
        this.msg = msg;
    }

    public MoveAxisRelativePLC(ByteBuffer data) {
        super(data);
        int index = data.getInt();
        double dist = data.getDouble();
        int millis = data.getInt();
        this.msg = new MoveAxisRelative(Axis.fromAxisNum(index).getName(), dist, Duration.ofMillis(millis));
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(this.msg.getAxisName()).getPLCAxisNum());
        data.putDouble(this.msg.getDistance());
        data.putInt((int)this.msg.getTime().toMillis());
    }

    @Override
    public String toString() {
        return "MoveAxisRelativePLC{" + super.toString() + " axis=" + this.msg.getAxisName() + ", distance=" + this.msg.getDistance() + ", time=" + this.msg.getTime() + '}';
    }
}

