/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.testbench.Led;

public class CanOpenLED
implements Led,
HasLifecycle {
    private CanOpenDAC dac;
    @ConfigurationParameter(range="0..4", description="The numero of the output of DAC where this led is plugged on.", units="unitless")
    private int outputNumero;

    public CanOpenDAC getDac() {
        return this.dac;
    }

    public int getOutputNumero() {
        return this.outputNumero;
    }

    public void setOutputNumero(int outputNumero) {
        this.outputNumero = outputNumero;
    }

    public void postStart() {
        if (this.dac.isBooted()) {
            this.dac.initializeAndCheckHardware();
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn on LED.")
    public String turnON() {
        this.dac.writeAnalogOutput(this.outputNumero, 81920);
        return "LED is turn ON";
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=1, description="Turn off LED.")
    public String turnOFF() {
        this.dac.writeAnalogOutput(this.outputNumero, 0);
        return "LED is turn OFF";
    }
}

