/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class INDIDateFormat {
    private static ThreadLocal<INDIDateFormat> format = new ThreadLocal();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    private INDIDateFormat() {
    }

    public static INDIDateFormat dateFormat() {
        INDIDateFormat result = format.get();
        if (result == null) {
            result = new INDIDateFormat();
            format.set(result);
        }
        return result;
    }

    public Date parseTimestamp(String time) {
        Date timestamp;
        if (time != null && !time.isEmpty()) {
            try {
                timestamp = this.dateFormat.parse(time);
            }
            catch (ParseException e) {
                try {
                    timestamp = this.dateFormat2.parse(time);
                }
                catch (ParseException ee) {
                    timestamp = new Date();
                }
            }
        } else {
            timestamp = new Date();
        }
        return timestamp;
    }

    public String formatTimestamp(Date timestamp) {
        return this.dateFormat.format(timestamp);
    }

    public String getCurrentTimestamp() {
        return this.formatTimestamp(new Date());
    }
}

