/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerSeneca;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselBrakes;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarouselSocket;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHYTTC580TemperaturesDevices;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByPlutoGateway;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGatherPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.ControllersViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.FcsGUI;
import org.lsst.ccs.subsystems.fcs.ui.FcsOverviewPanel;
import org.lsst.ccs.subsystems.fcs.ui.FiltersViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.TemperaturesViewPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenDevicePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.HYTTC580Panel;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class FcsGatherPanel
extends GatherPanel {
    private static final long serialVersionUID = 2279646593279606470L;
    private FcsGUI subs;
    private FcsOverviewPanel fcsOverviewPanel;
    private ControllersViewPanel controllersViewPanel;
    private TemperaturesViewPanel temperaturesViewPanel;
    private FiltersViewPanel filtersViewPanel;
    private CarouselGatherPanel carouselGatherPanel;
    private AutochangerGatherPanel autochangerGatherPanel;
    private LoaderGatherPanel loaderGatherPanel;

    public FcsGatherPanel(String tcpProxyName) {
        super(tcpProxyName);
    }

    public FcsGatherPanel(FcsGUI subs) {
        super("canbus0");
        this.subs = subs;
        this.fcsOverviewPanel = new FcsOverviewPanel();
        this.fcsOverviewPanel.setSubs(subs);
        this.filtersViewPanel = new FiltersViewPanel();
        this.controllersViewPanel = new ControllersViewPanel(subs);
        this.temperaturesViewPanel = new TemperaturesViewPanel();
        this.carouselGatherPanel = new CarouselGatherPanel(subs, "canbus0");
        this.autochangerGatherPanel = new AutochangerGatherPanel(subs, "canbus0");
        this.loaderGatherPanel = new LoaderGatherPanel(subs, "canbus1");
    }

    public FcsOverviewPanel getFcsOverviewPanel() {
        return this.fcsOverviewPanel;
    }

    public FiltersViewPanel getFiltersViewPanel() {
        return this.filtersViewPanel;
    }

    public ControllersViewPanel getControllersViewPanel() {
        return this.controllersViewPanel;
    }

    public TemperaturesViewPanel getTemperaturesViewPanel() {
        return this.temperaturesViewPanel;
    }

    public CarouselGatherPanel getCarouselGatherPanel() {
        return this.carouselGatherPanel;
    }

    public AutochangerGatherPanel getAutochangerGatherPanel() {
        return this.autochangerGatherPanel;
    }

    public LoaderGatherPanel getLoaderGatherPanel() {
        return this.loaderGatherPanel;
    }

    public EPOSControllerPanel getClampXminusControllerPanel() {
        return this.carouselGatherPanel.getClampXminusControllerPanel();
    }

    public EPOSControllerPanel getClampXplusControllerPanel() {
        return this.carouselGatherPanel.getClampXplusControllerPanel();
    }

    public EPOSControllerPanel getCarouselControllerPanel() {
        return this.carouselGatherPanel.getCarouselControllerPanel();
    }

    public HYTTC580Panel getHyTTCPanel() {
        return this.carouselGatherPanel.getHyTTCPanel();
    }

    public CanOpenDevicePanel getCancbxAI814Panel() {
        return this.carouselGatherPanel.getCancbxAI814Panel();
    }

    public CanOpenDevicePanel getCancbxPT100Panel() {
        return this.carouselGatherPanel.getCancbxPT100Panel();
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.autochangerGatherPanel.getPlutoGatewayPanel();
    }

    public CanOpenDevicePanel getOnlineStrainGaugePanel() {
        return this.autochangerGatherPanel.getOnlineStrainGaugePanel();
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.autochangerGatherPanel.getLatchXminusControllerPanel();
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.autochangerGatherPanel.getLatchXplusControllerPanel();
    }

    public EPOSControllerPanel getAcTruckXminusControllerPanel() {
        return this.autochangerGatherPanel.getAcTruckXminusControllerPanel();
    }

    public EPOSControllerPanel getAcTruckXplusControllerPanel() {
        return this.autochangerGatherPanel.getAcTruckXplusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampXminusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampXplusControllerPanel();
    }

    public EPOSControllerPanel getOnlineClampYminusControllerPanel() {
        return this.autochangerGatherPanel.getOnlineClampYminusControllerPanel();
    }

    @Override
    public InterfaceGeneralGUI getSubs() {
        return this.subs;
    }

    @Override
    public void updateFromStatusData(KeyValueData kvd) {
        String key = kvd.getKey();
        Serializable data = kvd.getValue();
        if ("canbus0".equals(key)) {
            this.updateCanOpenHardwarePanel((Integer)data);
        } else if (data instanceof StatusDataPublishedByEPOSController) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(key), (StatusDataPublishedByHardware)data);
            if ("carouselController".equals(Tools.getShortComponentName(key))) {
                this.fcsOverviewPanel.updateController((StatusDataPublishedByEPOSController)data);
            } else if ("carrierController".equals(Tools.getShortComponentName(key))) {
                this.fcsOverviewPanel.updateCarrierController((StatusDataPublishedByEPOSController)data);
            } else if ("hooksController".equals(Tools.getShortComponentName(key))) {
                this.fcsOverviewPanel.updateClampController((StatusDataPublishedByEPOSController)data);
            }
            this.controllersViewPanel.updateFromStatusData(kvd);
        } else if (data instanceof StatusDataPublishedByPlutoGateway) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(key), (StatusDataPublishedByHardware)data);
        } else if (data instanceof StatusDataPublishedByHardware) {
            this.updateCanOpenHardwarePanel(Tools.getShortComponentName(key), (StatusDataPublishedByHardware)data);
        } else if (data instanceof StatusDataPublishedByAutochangerTwoLatches || data instanceof StatusDataPublishedByCarouselSocket) {
            this.filtersViewPanel.updateFromStatusData(kvd);
        }
        if (data instanceof StatusDataPublishedByHYTTC580TemperaturesDevices || data instanceof StatusDataPublishedByAutochangerSeneca || data instanceof StatusDataPublishedByCarouselBrakes) {
            this.temperaturesViewPanel.updateFromStatusData(kvd);
        }
        this.carouselGatherPanel.updateFromStatusData(kvd);
        this.autochangerGatherPanel.updateFromStatusData(kvd);
        this.loaderGatherPanel.updateFromStatusData(kvd);
        this.fcsOverviewPanel.updateFromStatusData(kvd);
    }

    @Override
    public void updateFromConfigurationInfo(ConfigurationInfo configInfo) {
        this.carouselGatherPanel.updateFromConfigurationInfo(configInfo);
        this.autochangerGatherPanel.updateFromConfigurationInfo(configInfo);
        this.loaderGatherPanel.updateFromConfigurationInfo(configInfo);
    }

    @Override
    public void initializeGUIWithConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        super.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.carouselGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.autochangerGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
        this.controllersViewPanel.enableOnlineSubsystems(true, true, true);
    }

    @Override
    public void initializeGUIWithLoaderConfigInfo(ConfigurationInfo configInfo, List<String> hardwareNames) {
        this.loaderGatherPanel.initializeGUIWithConfigInfo(configInfo, hardwareNames);
    }

    @Override
    public void initializeGuiWithAutochangerSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithSensorsList: " + sensorsList.toString());
        this.autochangerGatherPanel.initializeGuiWithAutochangerSensorsList(configInfo, sensorsList);
    }

    @Override
    public void initializeGuiWithLoaderSensorsList(ConfigurationInfo configInfo, List<String> sensorsList) {
        FCSLOG.info("initializeGuiWithLoaderSensorsList: " + sensorsList.toString());
        this.loaderGatherPanel.initializeGuiWithLoaderSensorsList(configInfo, sensorsList);
    }

    @Override
    public void initializeGUIWithControllersMap(Map<String, String> controllersMap) {
        this.autochangerGatherPanel.initializeGUIWithControllersMap(controllersMap);
    }

    @Override
    public void initializeGUIWithFiltersInfo(ConfigurationInfo configInfo, List<String> filterNamesList) throws InterruptedException, InvocationTargetException {
        this.carouselGatherPanel.initializeGUIWithFiltersInfo(configInfo, filterNamesList);
        this.filtersViewPanel.initializeGui(configInfo, filterNamesList);
    }

    @Override
    public void resetPanel() {
        super.resetPanel();
        this.carouselGatherPanel.resetPanel();
        this.autochangerGatherPanel.resetPanel();
        this.loaderGatherPanel.resetPanel();
    }
}

