/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.util.logging.Logger;
import org.lsst.ccs.subsystems.fcs.ui.commons.InterfaceGeneralGUI;

public interface InterfaceAutochangerGUI
extends InterfaceGeneralGUI {
    public static final Logger FCSLOG = Logger.getLogger(InterfaceAutochangerGUI.class.getName());

    public long getTimeoutForTrucksMotion();

    public long getTimeoutForOnlineClampMotion();

    public long getTimeoutForLatchesMotion();

    public long getTimeoutForAlignFollower();

    public void setTimeoutForTrucksMotion(long var1);

    public void setTimeoutForOnlineClampMotion(long var1);

    public void setTimeoutForLatchesMotion(long var1);

    public void setTimeoutForAlignFollower(long var1);

    default public void updateAutochangerTrucksPosition() {
        FCSLOG.info("Updating autochanger trucks position");
        FCSLOG.info("/timeout=1000");
        this.sendCommand("updatePosition", 1000L, "autochanger/autochangerTrucks");
    }

    default public void acAlignFollower() {
        FCSLOG.info("Autochanger aligning follower");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("alignFollower", this.getTimeoutForAlignFollower(), "autochanger");
    }

    default public void acAlignFollowerForLoader() {
        FCSLOG.info("Autochanger aligning follower for loader");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("alignFollowerForLoader", this.getTimeoutForAlignFollower(), "autochanger");
    }

    default public void acGoToHandOff() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("goToHandOff", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToHandOffForLoader() {
        FCSLOG.info("Autochanger Trucks going to Handoff Position for Loader");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("goToHandOffForLoader", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToStandby() {
        FCSLOG.info("Autochanger Trucks going to Standby Position");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("goToStandby", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acMoveToApproachStandby() {
        FCSLOG.info("Autochanger Trucks going to Approach Standby Position");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("moveToApproachStandby", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acGoToOnline() {
        FCSLOG.info("Autochanger Trucks going to Online Position");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("goToOnline", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acMoveAndClampFilterOnline() {
        FCSLOG.info("Autochanger Trucks moving to Online Position, and clamping");
        FCSLOG.info("/timeout=" + this.getTimeoutForTrucksMotion());
        this.sendCommand("moveAndClampFilterOnline", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void acSlowTrucksProfile() {
        long timeout = 2000L;
        FCSLOG.info("Setting trucks slow velocity and acceleration profile");
        FCSLOG.info("/timeout=" + timeout);
        this.sendCommand("slowTrucksProfile", timeout, "autochanger");
    }

    default public void acFastTrucksProfile() {
        long timeout = 2000L;
        FCSLOG.info("Setting trucks fast velocity and acceleration profile");
        FCSLOG.info("/timeout=" + timeout);
        this.sendCommand("fastTrucksProfile", timeout, "autochanger");
    }

    default public void acUnclampAndMoveFilterToHandoff() {
        this.sendCommand("unclampAndMoveFilterToHandoff", this.getTimeoutForTrucksMotion(), "autochanger");
    }

    default public void unlockOnlineClamps() {
        FCSLOG.info("Autochanger unlocking online clamps");
        this.sendCommand("unlockClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void lockOnlineClamps() {
        FCSLOG.info("Autochanger locking online clamps");
        this.sendCommand("lockClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void closeOnlineClamps() {
        FCSLOG.info("Autochanger closing online clamps");
        this.sendCommand("closeClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void homingOnlineClamps() {
        FCSLOG.info("Autochanger online clamps homing");
        this.sendCommand("homing", this.getTimeoutForOnlineClampMotion(), "autochanger/onlineClamps");
    }

    default public void openOnlineClamps() {
        FCSLOG.info("Autochanger opening online clamps");
        this.sendCommand("openClamps", this.getTimeoutForOnlineClampMotion(), "autochanger");
    }

    default public void homingOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger homing online clamp: " + clampName);
        this.sendCommand("openInCurrentModeAndHoming", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void openOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger opening clamp: " + clampName);
        this.sendCommand("open", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void closeOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger closing clamp: " + clampName);
        this.sendCommand("close", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void lockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger clamping clamp: " + clampName);
        this.sendCommand("lock", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void unlockOnlineClamp(String clampName) {
        FCSLOG.info("Autochanger unclamping clamp: " + clampName);
        this.sendCommand("unlock", this.getTimeoutForOnlineClampMotion(), clampName);
    }

    default public void closeLatch(String latchName) {
        FCSLOG.info("Autochanger opening latch: " + latchName);
        FCSLOG.info("/timeout=" + this.getTimeoutForLatchesMotion());
        this.sendCommand("close", this.getTimeoutForLatchesMotion(), latchName);
    }

    default public void openLatch(String latchName) {
        FCSLOG.info("Autochanger closing latch: " + latchName);
        FCSLOG.info("/timeout=" + this.getTimeoutForLatchesMotion());
        this.sendCommand("open", this.getTimeoutForLatchesMotion(), latchName);
    }

    default public void closeLatches() {
        FCSLOG.info("Autochanger closing latches.");
        FCSLOG.info("/timeout=" + this.getTimeoutForLatchesMotion());
        this.sendCommand("closeLatches", this.getTimeoutForLatchesMotion(), "autochanger");
    }

    default public void openLatches() {
        FCSLOG.info("Autochanger opening latches.");
        FCSLOG.info("/timeout=" + this.getTimeoutForLatchesMotion());
        this.sendCommand("openLatches", this.getTimeoutForLatchesMotion(), "autochanger");
    }
}

