/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class InputFilteringPanel
extends JLayeredPane {
    private final JComponent content;
    private final JPanel filter;
    private boolean blocked;
    private ArrayList<Listener> listeners;
    int i = 0;

    public InputFilteringPanel(JComponent payload) {
        this.content = payload;
        this.setPreferredSize(this.content.getPreferredSize());
        this.add((Component)this.content, (Object)1);
        this.filter = new JPanel();
        this.filter.setOpaque(false);
        this.add((Component)this.filter, (Object)0);
        Dimension paneSize = this.getSize();
        this.content.setBounds(0, 0, paneSize.width, paneSize.height);
        this.filter.setBounds(0, 0, paneSize.width, paneSize.height);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension newSize = InputFilteringPanel.this.getSize();
                InputFilteringPanel.this.content.setBounds(0, 0, newSize.width, newSize.height);
                InputFilteringPanel.this.filter.setBounds(0, 0, newSize.width, newSize.height);
            }
        });
        MouseAdapter m = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                e.consume();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
                InputFilteringPanel.this.showPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                InputFilteringPanel.this.showPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                InputFilteringPanel.this.onBlock(e);
            }
        };
        this.filter.addMouseListener(m);
        this.filter.addMouseMotionListener(m);
        this.filter.addMouseWheelListener(m);
    }

    public JComponent getContent() {
        return this.content;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        if (blocked != this.blocked) {
            this.blocked = blocked;
            if (blocked) {
                this.setLayer(this.filter, 2);
                this.content.setFocusable(false);
            } else {
                this.setLayer(this.filter, 0);
                this.content.setFocusable(true);
            }
            this.notifyListeners();
        }
    }

    public void addListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        } else {
            this.listeners.ensureCapacity(this.listeners.size() + 1);
        }
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            } else {
                this.listeners.trimToSize();
            }
        }
    }

    public void removeAllListeners() {
        this.listeners = null;
    }

    protected void notifyListeners() {
        if (this.listeners != null) {
            Event e = new Event(this);
            SwingUtilities.invokeLater(() -> this.listeners.forEach(l -> l.onChange(e)));
        }
    }

    protected void showPopup(MouseEvent e) {
        if (this.blocked && e.isPopupTrigger()) {
            JPopupMenu popupMenu = new JPopupMenu();
            AbstractAction a = new AbstractAction("Enable Input"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InputFilteringPanel.this.setBlocked(false);
                }
            };
            JMenuItem menuItem = new JMenuItem(a);
            popupMenu.add(menuItem);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void onBlock(MouseEvent e) {
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JPanel contentPane = new JPanel();
            InputFilteringPanel filteringPane = new InputFilteringPanel(contentPane);
            contentPane.setBorder(BorderFactory.createLineBorder(Color.GREEN, 5));
            JButton b = new JButton("Button");
            b.addActionListener(e -> System.out.println("Button Pressed"));
            contentPane.add(b);
            contentPane.add(new JLabel(" Label "));
            b = new JButton("Enable filtering");
            b.addActionListener(e -> {
                boolean was = filteringPane.isBlocked();
                ((JButton)e.getSource()).setText("Toggle filtering");
                filteringPane.setBlocked(!was);
            });
            contentPane.add(b);
            filteringPane.setOpaque(true);
            JFrame frame = new JFrame("InputFilteringPanel Demo");
            frame.setDefaultCloseOperation(3);
            frame.setContentPane(filteringPane);
            frame.setSize(500, 500);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public static class Event
    extends EventObject {
        private final boolean active = this.getSource().isBlocked();

        protected Event(InputFilteringPanel source) {
            super(source);
        }

        @Override
        public InputFilteringPanel getSource() {
            return (InputFilteringPanel)super.getSource();
        }

        public boolean isActive() {
            return this.active;
        }

        public JComponent getComponent() {
            return this.getSource().getContent();
        }
    }

    public static interface Listener {
        public void onChange(Event var1);
    }
}

