/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.ConfigurationFilter;
import org.lsst.ccs.gconsole.plugins.monitor.ComboGroupView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPage;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public class ConfigurationView
extends ComboGroupView {
    public static final String PAGE_CREATOR_PATH = "Built-In/Miscellaneous/Configuration";
    public static final String PAGE_CREATOR_PATH_WHOLECAMERA = "Built-In/Whole Camera/Configuration";
    private JPanel root;
    private final Action onSave = new AbstractAction("Save"){

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] target = ConfigurationView.this.getTarget();
            if (target != null) {
                CommandService.getService().send(target[0], "saveChangesForCategories", target[1]);
            }
        }
    };
    private final Action onDrop = new AbstractAction("Drop"){

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] target = ConfigurationView.this.getTarget();
            if (target != null) {
                CommandService.getService().send(target[0], "dropChangesForCategories", target[1]);
            }
        }
    };

    public ConfigurationView() {
        super(0, null);
    }

    @Override
    public JComponent getPanel() {
        if (this.root == null) {
            this.root = new JPanel(new BorderLayout());
            JComponent viewPanel = super.getPanel();
            viewPanel.setBorder(BorderFactory.createEtchedBorder());
            this.root.add((Component)viewPanel, "Center");
            Box buttonPanel = Box.createHorizontalBox();
            buttonPanel.add(Box.createHorizontalGlue());
            JButton saveButton = new JButton(this.onSave);
            buttonPanel.add(saveButton);
            buttonPanel.add(Box.createRigidArea(Const.HDIM));
            JButton dropButton = new JButton(this.onDrop);
            buttonPanel.add(dropButton);
            this.root.add((Component)buttonPanel, "South");
        }
        return this.root;
    }

    private String[] getTarget() {
        try {
            String[] gg = this.getPath(this.currentGroup);
            switch (gg.length) {
                case 1: {
                    String agent = this.getFilter().getAgents().get(0);
                    return new String[]{agent, gg[0]};
                }
                case 2: {
                    return gg;
                }
            }
            return null;
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException x) {
            return null;
        }
    }

    @Create(category="MonitorPage", name="Configuration", path="Built-In/Miscellaneous/Configuration", description="Configurations for one or more subsystems, organized by category.")
    public static MonitorPage makeConfigPage(@Par(def="_null_", desc="Page name. If not specified, the page will be named after the selected subsystem.") String name, @Par(def="_null_", desc="List of subsystem names. If null, configurations for all subsystems are displayed.") List<String> subsystems) {
        String[] stringArray;
        if (subsystems != null && subsystems.isEmpty()) {
            subsystems = null;
        }
        name = name == null || name.trim().isEmpty() ? (subsystems == null || subsystems.size() != 1 ? "Config" : subsystems.get(0)) : name;
        ConfigurationView view = new ConfigurationView();
        ComboGroupView.Descriptor descriptor = view.getDescriptor();
        if (subsystems == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Subsystem";
            stringArray = stringArray2;
            stringArray2[1] = "Category";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "Category";
        }
        descriptor.setLabels(stringArray);
        return new MonitorPage(view, new ConfigurationFilter(null, subsystems), name){

            @Override
            public MonitorPage edit(String title, Component parent) {
                return null;
            }

            @Override
            public void restore(Persistable.Descriptor descriptor) {
                try {
                    this.getView().restore(((MonitorPage.Descriptor)descriptor).getView());
                }
                catch (ClassCastException | NullPointerException runtimeException) {
                    // empty catch block
                }
            }
        };
    }

    @Create(category="MonitorPage", name="Configuration", path="Built-In/Whole Camera/Configuration", description="Configurations for the whole camera, organized by subsystem and category.")
    public static MonitorPage makeConfigPage() {
        return ConfigurationView.makeConfigPage(null, null);
    }
}

