/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.console;

import java.util.Properties;
import javax.swing.JComponent;
import org.freehep.application.PropertyUtilities;
import org.freehep.jas.plugin.console.ConsolePlugin;
import org.freehep.jas.plugin.console.ConsolePreferencesPanel;
import org.freehep.jas.services.PreferencesTopic;

class ConsolePreferences
implements PreferencesTopic {
    private static final String _keyPrefix = "core.console.";
    private static final String _redirectOutKey = "redirectOut";
    private static final String _redirectErrKey = "redirectErr";
    private static final String _autoShowOutKey = "autoShowOut";
    private static final String _autoShowErrKey = "autoShowErr";
    private static final String _defaultScrollbackKey = "defaultScrollback";
    private static final boolean _redirectOutDefault = true;
    private static final boolean _redirectErrDefault = false;
    private static final boolean _autoShowOutDefault = false;
    private static final boolean _autoShowErrDefault = false;
    private static final int _defaultScrollbackDefault = 1000;
    private boolean redirectStandardOutput;
    private boolean autoShowStandardOutput;
    private boolean redirectStandardError;
    private boolean autoShowStandardError;
    private int defaultScrollback;
    private final ConsolePlugin _consolePlugin;

    ConsolePreferences(ConsolePlugin consolePlugin) {
        this._consolePlugin = consolePlugin;
        Properties prop = this._consolePlugin.getApplication().getUserProperties();
        this.redirectStandardOutput = PropertyUtilities.getBoolean((Properties)prop, (String)"core.console.redirectOut", (boolean)true);
        this.redirectStandardError = PropertyUtilities.getBoolean((Properties)prop, (String)"core.console.redirectErr", (boolean)false);
        this.autoShowStandardOutput = PropertyUtilities.getBoolean((Properties)prop, (String)"core.console.autoShowOut", (boolean)false);
        this.autoShowStandardError = PropertyUtilities.getBoolean((Properties)prop, (String)"core.console.autoShowErr", (boolean)false);
        this.defaultScrollback = PropertyUtilities.getInteger((Properties)prop, (String)"core.console.defaultScrollback", (int)1000);
    }

    @Override
    public boolean apply(JComponent panel) {
        ConsolePreferencesPanel gui = (ConsolePreferencesPanel)panel;
        Properties prop = this._consolePlugin.getApplication().getUserProperties();
        this.redirectStandardOutput = gui.isRedirectStandardOut();
        PropertyUtilities.setBoolean((Properties)prop, (String)"core.console.redirectOut", (boolean)this.redirectStandardOutput);
        this.redirectStandardError = gui.isRedirectStandardError();
        PropertyUtilities.setBoolean((Properties)prop, (String)"core.console.redirectErr", (boolean)this.redirectStandardError);
        this.autoShowStandardOutput = gui.isAutoShowStandardOut();
        PropertyUtilities.setBoolean((Properties)prop, (String)"core.console.autoShowOut", (boolean)this.autoShowStandardOutput);
        this.autoShowStandardError = gui.isAutoShowStandardError();
        PropertyUtilities.setBoolean((Properties)prop, (String)"core.console.autoShowErr", (boolean)this.autoShowStandardError);
        this.defaultScrollback = gui.getDefaultsScrollback();
        PropertyUtilities.setInteger((Properties)prop, (String)"core.console.defaultScrollback", (int)this.defaultScrollback);
        this._consolePlugin.preferencesChanged(this);
        return true;
    }

    @Override
    public JComponent component() {
        ConsolePreferencesPanel gui = new ConsolePreferencesPanel();
        gui.setRedirectStandardOut(this.redirectStandardOutput);
        gui.setRedirectStandardError(this.redirectStandardError);
        gui.setAutoShowStandardOut(this.autoShowStandardOutput);
        gui.setAutoShowStandardError(this.autoShowStandardError);
        gui.setDefaultsScrollback(this.defaultScrollback);
        return gui;
    }

    @Override
    public String[] path() {
        return new String[]{"General", "Console"};
    }

    boolean isRedirectStandardOutput() {
        return this.redirectStandardOutput;
    }

    boolean isAutoShowStandardOutput() {
        return this.autoShowStandardOutput;
    }

    boolean isRedirectStandardError() {
        return this.redirectStandardError;
    }

    boolean isAutoShowStandardError() {
        return this.autoShowStandardError;
    }

    int getDefaultScrollback() {
        return this.defaultScrollback;
    }
}

