/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.camera.kafka.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.lsst.ccs.camera.kafka.avro.Topic;

abstract class AvroSchemaUtils {
    AvroSchemaUtils() {
    }

    static Schema generateSchemaForTopic(Topic t) {
        Schema avroSchema = Schema.createRecord((String)t.getName(), null, (String)t.getNameSpace(), (boolean)false);
        Schema.Type nullType = Schema.Type.NULL;
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
        for (Topic.TopicField f : t.getFields()) {
            Schema schemaType = Schema.create((Schema.Type)Schema.Type.valueOf((String)f.getType().toUpperCase()));
            Object defaultValue = null;
            if (!f.getName().equals("timestamp")) {
                schemaType = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)nullType), schemaType});
                defaultValue = Schema.Field.NULL_DEFAULT_VALUE;
            }
            Schema.Field schemaField = new Schema.Field(f.getName(), schemaType, null, defaultValue);
            schemaField.addProp("description", f.getDescription());
            schemaField.addProp("units", f.getUnits());
            schemaFields.add(schemaField);
        }
        for (String tag : t.getTags()) {
            Schema.Field schemaField = new Schema.Field(tag, Schema.create((Schema.Type)Schema.Type.STRING), null);
            schemaField.addProp("description", "This is a tag");
            schemaFields.add(schemaField);
        }
        avroSchema.setFields(schemaFields);
        return avroSchema;
    }

    static Schema updateSchemaForTopic(Schema existingSchema, Topic t) {
        if (!existingSchema.getNamespace().equals(t.getNameSpace()) || !existingSchema.getName().equals(t.getName())) {
            throw new RuntimeException("Name/Namespace inconstency for schema " + existingSchema.toString(true) + " and topic " + t);
        }
        Schema newSchema = AvroSchemaUtils.generateSchemaForTopic(t);
        ArrayList<Schema.Field> deletedFields = new ArrayList<Schema.Field>();
        for (Schema.Field existingField : existingSchema.getFields()) {
            if (newSchema.getField(existingField.name()) != null) continue;
            deletedFields.add(existingField);
        }
        if (!deletedFields.isEmpty()) {
            Schema mergedSchema = Schema.createRecord((String)t.getName(), null, (String)t.getNameSpace(), (boolean)false);
            ArrayList<Schema.Field> mergedFields = new ArrayList<Schema.Field>();
            List newSchemaFields = newSchema.getFields();
            for (Schema.Field newField : newSchemaFields) {
                mergedFields.add(AvroSchemaUtils.cloneField(newField));
            }
            for (Schema.Field deletedField : deletedFields) {
                mergedFields.add(AvroSchemaUtils.cloneField(deletedField));
            }
            mergedSchema.setFields(mergedFields);
            newSchema = mergedSchema;
        }
        return newSchema;
    }

    private static Schema.Field cloneField(Schema.Field f) {
        Schema.Field clone = new Schema.Field(f.name(), f.schema(), null, f.defaultVal());
        for (Map.Entry e : f.getObjectProps().entrySet()) {
            clone.addProp((String)e.getKey(), e.getValue());
        }
        return clone;
    }
}

