/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import data.DiscretePlotData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import menus.IncludeInMenu;
import org.freehep.util.Value;
import plotter.Axis;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;

public class DataPointChartOverlay
extends DataOverlay {
    private ContinuousAxisModel xModel;
    private ContinuousAxisModel yModel;
    private final DiscretePlotData data;
    private float lineWidth = 2.0f;
    private Color lineColor = Color.RED;
    private final int xDim;
    private final int yDim;
    private final int xPlusErrorDim;
    private final int xMinusErrorDim;
    private final int yPlusErrorDim;
    private final int yMinusErrorDim;

    public DataPointChartOverlay(String title, DiscretePlotData data, int xDim, int yDim, int xPlusErrorDim, int xMinusErrorDim, int yPlusErrorDim, int yMinusErrorDim, ContinuousAxisModel x, ContinuousAxisModel y) {
        super(title);
        this.data = data;
        this.xModel = x;
        this.yModel = y;
        this.xDim = xDim;
        this.yDim = yDim;
        this.xPlusErrorDim = xPlusErrorDim;
        this.xMinusErrorDim = xMinusErrorDim;
        this.yPlusErrorDim = yPlusErrorDim;
        this.yMinusErrorDim = yMinusErrorDim;
    }

    @Override
    protected void paint(Graphics2D g) {
        DataArea da = this.getDataArea();
        Axis xAxis = da.getAxisForModel(this.xModel);
        Axis yAxis = da.getAxisForModel(this.yModel);
        GeneralPath poly = new GeneralPath();
        Value value = new Value();
        for (int i = 0; i < this.data.getNPoints(); ++i) {
            this.data.getValue(value, this.xDim, i);
            double xValue = value.getDouble();
            double x = xAxis.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getAxisCoordinateFromModelCoordinate(xValue), da);
            this.data.getValue(value, this.yDim, i);
            double yValue = value.getDouble();
            double y = yAxis.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(yValue), da);
            if (this.yPlusErrorDim > 0 && this.yMinusErrorDim > 0) {
                this.data.getValue(value, this.yPlusErrorDim, i);
                double yPlusValue = value.getDouble();
                this.data.getValue(value, this.yMinusErrorDim, i);
                double yMinusValue = value.getDouble();
                double yplus = yAxis.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(yValue + yPlusValue), da);
                double yminus = yAxis.getPhysicalCoordinateFromAxisCoordinate(this.yModel.getAxisCoordinateFromModelCoordinate(yValue - yMinusValue), da);
                poly.moveTo(x, yplus);
                poly.lineTo(x, yminus);
            }
            if (this.xPlusErrorDim <= 0 || this.xMinusErrorDim <= 0) continue;
            this.data.getValue(value, this.xPlusErrorDim, i);
            double xPlusValue = value.getDouble();
            this.data.getValue(value, this.xMinusErrorDim, i);
            double xMinusValue = value.getDouble();
            double xplus = yAxis.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getAxisCoordinateFromModelCoordinate(xValue + xPlusValue), da);
            double xminus = yAxis.getPhysicalCoordinateFromAxisCoordinate(this.xModel.getAxisCoordinateFromModelCoordinate(xValue - xMinusValue), da);
            poly.moveTo(xplus, y);
            poly.lineTo(xminus, y);
        }
        BasicStroke s = new BasicStroke(this.lineWidth, 2, 1);
        g.setStroke(s);
        g.setColor(this.lineColor);
        g.draw(poly);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @IncludeInMenu(value="Line Color")
    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    @IncludeInMenu(value="Line Width")
    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Icon getKeyIcon() {
        return new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                BasicStroke s = new BasicStroke(DataPointChartOverlay.this.lineWidth, 2, 1);
                g2.setStroke(s);
                g2.setColor(DataPointChartOverlay.this.lineColor);
                GeneralPath poly = new GeneralPath();
                poly.moveTo(0.0f, 5.0f);
                poly.lineTo(10.0f, 5.0f);
                g2.draw(poly);
            }

            @Override
            public int getIconWidth() {
                return 10;
            }

            @Override
            public int getIconHeight() {
                return 10;
            }
        };
    }
}

