/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plotter.LinearAxisModel;

public class AutoRangeAxisModel
extends LinearAxisModel {
    private LinearAxisModel source;
    private double scaleFactor = 0.05;
    private boolean requireZero;

    AutoRangeAxisModel(LinearAxisModel source) {
        super(0.0, 1.0);
        this.source = source;
        double sourceMin = source.getModelCoordinateFromAxisCoordinate(0.0);
        double sourceMax = source.getModelCoordinateFromAxisCoordinate(1.0);
        this.computeMinMax(sourceMin, sourceMax);
        source.addChangeListener(new ModelListener());
    }

    private void computeMinMax(double sourceMin, double sourceMax) {
        double range = sourceMax - sourceMin;
        double pow = Math.floor(Math.log10(range));
        double conversion = Math.pow(10.0, pow + 1.0);
        double scale = conversion * this.scaleFactor;
        double max = Math.ceil(sourceMax / scale) * scale;
        double min = Math.floor(sourceMin / scale) * scale;
        this.setRange(min, max);
    }

    public static void main(String[] args) {
        new AutoRangeAxisModel(new LinearAxisModel(2.0, 98.0));
        new AutoRangeAxisModel(new LinearAxisModel(3.0, 55.0));
        new AutoRangeAxisModel(new LinearAxisModel(0.03, 0.55));
        new AutoRangeAxisModel(new LinearAxisModel(3000000.0, 5.5E7));
        new AutoRangeAxisModel(new LinearAxisModel(3.0, 52.0));
        new AutoRangeAxisModel(new LinearAxisModel(-3.0, 3.0));
        new AutoRangeAxisModel(new LinearAxisModel(-3.0, 3.1));
        new AutoRangeAxisModel(new LinearAxisModel(100.0, 101.0));
        new AutoRangeAxisModel(new LinearAxisModel(10000.0, 10000.00001));
    }

    private class ModelListener
    implements ChangeListener {
        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double newMin = AutoRangeAxisModel.this.source.getModelCoordinateFromAxisCoordinate(0.0);
            double newMax = AutoRangeAxisModel.this.source.getModelCoordinateFromAxisCoordinate(1.0);
            AutoRangeAxisModel.this.computeMinMax(newMin, newMax);
        }
    }
}

