/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.refrig.constants.ChillerLatches;
import org.lsst.ccs.subsystem.refrig.constants.ChillerPLCState;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ChillerPlcState;

public class ChillerPlcControlPanel
extends JPanel
implements UiUtilities.ActionHandler {
    private static final Map<Integer, String> latches = new LinkedHashMap<Integer, String>();
    private static final Map<Integer, String> conditions;
    private JPanel plcPanel;
    private JLabel plcStatus;
    private JLabel switchStatus;
    private ButtonGroup switchBG;
    private JRadioButton switchOffRB;
    private JRadioButton switchOnRB;
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[7];
    private final JLabel[] latchStatus = new JLabel[7];
    private final JButton[] latchResetBtn = new JButton[7];
    private JPanel conditionPanel;
    private final JLabel[] conditionStatus = new JLabel[12];
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private static final long serialVersionUID = 1L;

    public ChillerPlcControlPanel(CommandSender sender) {
        this.sender = sender;
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void updatePanel(ChillerPlcState ps) {
        SwingUtilities.invokeLater(new UpdatePlcStatus(ps));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.plcStatus = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(ChillerPLCState.class));
        this.switchStatus = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(SwitchState.class));
        this.switchOffRB = this.uiUtils.newRadioButton("Off", "F");
        this.switchOnRB = this.uiUtils.newRadioButton("On", "T");
        ButtonGroup bg = this.switchBG = new ButtonGroup();
        bg.add(this.switchOffRB);
        bg.add(this.switchOnRB);
        for (int cond : latches.keySet()) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latches.get(cond) + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(LatchState.class));
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", String.valueOf(cond), true);
        }
        for (int cond : conditions.keySet()) {
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"XXX", (int)UiUtilities.maxEnumLabelWidth(ConditionState.class));
        }
        this.plcPanel = UiUtilities.newBorderedPanel((String)"PLC State");
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.anchor = 17;
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.insets = new Insets(4, 4, 4, 4);
        this.plcPanel.add((Component)UiUtilities.newLabel((String)"PLC state:", (int)0), gbp);
        ++gbp.gridx;
        gbp.insets.left = 4;
        this.plcPanel.add((Component)this.plcStatus, gbp);
        ++gbp.gridx;
        gbp.insets.left = 35;
        this.plcPanel.add((Component)UiUtilities.newLabel((String)"Enable chiller:", (int)0), gbp);
        gbp.insets.left = 4;
        ++gbp.gridx;
        this.plcPanel.add((Component)this.switchStatus, gbp);
        ++gbp.gridx;
        this.plcPanel.add((Component)this.switchOffRB, gbp);
        ++gbp.gridx;
        this.plcPanel.add((Component)this.switchOnRB, gbp);
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.anchor = 17;
        gbl.insets = new Insets(0, 0, 4, 4);
        gbl.insets.bottom = 4;
        gbl.gridy = -1;
        int numColm = 1;
        int colm = 0;
        for (int cond : latches.keySet()) {
            if (colm == 0) {
                gbl.gridx = 0;
                ++gbl.gridy;
            }
            gbl.insets.top = gbl.gridy == 0 ? 4 : 0;
            gbl.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond], gbl);
            gbl.insets.left = 4;
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbl);
            ++gbl.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbl);
            ++gbl.gridx;
            colm = (colm + 1) % numColm;
        }
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        numColm = 1;
        colm = 0;
        for (int cond : conditions.keySet()) {
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 35;
            this.conditionPanel.add((Component)UiUtilities.newLabel((String)(conditions.get(cond) + ":"), (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % numColm;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.anchor = 11;
        gbm.insets = new Insets(6, 4, 6, 4);
        gbm.gridwidth = 2;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.add((Component)this.plcPanel, gbm);
        gbm.gridwidth = 1;
        ++gbm.gridy;
        this.add((Component)this.latchPanel, gbm);
        ++gbm.gridx;
        this.add((Component)this.conditionPanel, gbm);
    }

    public void handleRadioButton(String name) {
        char action = name.charAt(0);
        this.switchOffRB.setEnabled(false);
        this.switchOnRB.setEnabled(false);
        this.sender.sendCommand(null, "enableChiller", new Object[]{action == 'T'});
    }

    public void handleButton(String name) {
        int latch = Integer.valueOf(name);
        this.latchResetBtn[latch].setEnabled(false);
        this.sender.sendCommand(null, "clearPlcLatch", new Object[]{ChillerLatches.getName(latch)});
    }

    static {
        latches.put(1, "External Permit");
        latches.put(2, "Chiller EMO Button");
        latches.put(0, "Smoke Detector");
        latches.put(5, "Leak Detector");
        latches.put(6, "Leak Detc Fault");
        latches.put(3, "Burst Disc Supp > 5");
        latches.put(4, "Burst Disc Retn > 5");
        conditions = new LinkedHashMap<Integer, String>();
        conditions.put(4, "Enable switch on");
        conditions.put(1, "Keyswitch on");
        conditions.put(6, "Chiller enabled");
        conditions.put(8, "Burst Disc Supp < 4.5");
        conditions.put(10, "Burst Disc Retn < 4.5");
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ChillerPlcControlPanel.this.plcStatus.setEnabled(false);
            ChillerPlcControlPanel.this.switchStatus.setEnabled(false);
            ChillerPlcControlPanel.this.switchOffRB.setEnabled(false);
            ChillerPlcControlPanel.this.switchOnRB.setEnabled(false);
            for (int cond : latches.keySet()) {
                ChillerPlcControlPanel.this.latchStatus[cond].setEnabled(false);
                ChillerPlcControlPanel.this.latchResetBtn[cond].setEnabled(false);
            }
            for (int cond : conditions.keySet()) {
                ChillerPlcControlPanel.this.conditionStatus[cond].setEnabled(false);
            }
            ChillerPlcControlPanel.this.repaint();
        }
    }

    class UpdatePlcStatus
    implements Runnable {
        private final ChillerPlcState ps;

        UpdatePlcStatus(ChillerPlcState ps) {
            this.ps = ps;
        }

        @Override
        public void run() {
            Enum state;
            ChillerPLCState plcState = this.ps.getPlcState();
            ChillerPlcControlPanel.this.plcStatus.setText(plcState.name());
            ChillerPlcControlPanel.this.plcStatus.setForeground(plcState == ChillerPLCState.OFFLINE ? UiConstants.BLUE : (plcState == ChillerPLCState.PLC_DEAD ? UiConstants.RED : (plcState == ChillerPLCState.RUNNING ? UiConstants.GREEN : Color.BLACK)));
            ChillerPlcControlPanel.this.plcStatus.setEnabled(true);
            SwitchState swState = this.ps.getSwitchState(0);
            ChillerPlcControlPanel.this.switchStatus.setText(swState.name());
            Color color = swState == SwitchState.OFF ? Color.black : (swState == SwitchState.ON ? UiConstants.GREEN : UiConstants.BLUE);
            ChillerPlcControlPanel.this.switchStatus.setForeground(color);
            JRadioButton selButton = swState == SwitchState.ON ? ChillerPlcControlPanel.this.switchOnRB : ChillerPlcControlPanel.this.switchOffRB;
            selButton.setSelected(true);
            ChillerPlcControlPanel.this.switchStatus.setEnabled(true);
            ChillerPlcControlPanel.this.switchOffRB.setEnabled(true);
            ChillerPlcControlPanel.this.switchOnRB.setEnabled(true);
            for (int cond : latches.keySet()) {
                state = this.ps.getLatch(cond);
                ChillerPlcControlPanel.this.latchStatus[cond].setText(state.name());
                ChillerPlcControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                ChillerPlcControlPanel.this.latchStatus[cond].setEnabled(true);
                ChillerPlcControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            for (int cond : conditions.keySet()) {
                state = this.ps.getCondition(cond);
                ChillerPlcControlPanel.this.conditionStatus[cond].setText(state.name());
                ChillerPlcControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                ChillerPlcControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            ChillerPlcControlPanel.this.repaint();
        }
    }
}

