/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.basic.FileOpener;
import org.freehep.jas.plugin.tree.DefaultFTree;
import org.freehep.jas.plugin.tree.DefaultFTreeNode;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterRegistry;
import org.freehep.jas.plugin.tree.DefaultJTree;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeFolderNode;
import org.freehep.jas.plugin.tree.FTreeLeafNode;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAdapterRegistry;
import org.freehep.jas.plugin.tree.FTreeNodeRenamedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeSorter;
import org.freehep.jas.plugin.tree.FTreeNodeSorterManager;
import org.freehep.jas.plugin.tree.FTreeNodeTextChangeEvent;
import org.freehep.jas.plugin.tree.FTreePreferencesDialog;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.plugin.tree.FTreeUtils;
import org.freehep.jas.plugin.tree.SorterAlphaNumerical;
import org.freehep.jas.plugin.tree.SorterAlphabetical;
import org.freehep.jas.plugin.tree.SorterCreationOrder;
import org.freehep.jas.plugin.tree.SorterFolderFirst;
import org.freehep.jas.plugin.xmlio.XMLPluginIO;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.util.FreeHEPLookup;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.images.ImageHandler;
import org.freehep.util.template.Template;
import org.freehep.xml.io.XMLIOManager;
import org.jdom.Content;
import org.jdom.Element;
import org.xml.sax.SAXException;

public class FTreePlugin
extends Plugin
implements FTreeProvider,
XMLPluginIO,
PreferencesTopic {
    private static Studio app;
    private Set oldCommandProcessors = Collections.EMPTY_SET;
    private List eventList;
    private Hashtable trees = new Hashtable();
    private Hashtable defaultJTrees = new Hashtable();
    private static FTreePlugin thePlugin;
    private Properties userProperties;
    private static FTreeNodeSorter defaultSorter;
    private static final Icon openNonSelectedFolderIcon;
    private static final Icon closedNonSelectedFolderIcon;
    private static final Icon openSelectedFolderIcon;
    private static final Icon closedSelectedFolderIcon;
    private static final Icon nonSelectedLeafIcon;
    private static final Icon selectedLeafIcon;
    private FTreeNodeAdapterRegistry adapterRegistry;
    private FileOpener fileOpener;
    private static final String FTreePLUGIN_TREE_SORTING = "org.freehep.jas.plugin.tree.treeSortingAlgorithm.";
    private static final String FTreePLUGIN_IS_SORTING_RECURSIVE = "org.freehep.jas.plugin.tree.isSortingRecursive.";

    protected void init() throws SAXException, IOException {
        thePlugin = this;
        app = this.getApplication();
        this.userProperties = app.getUserProperties();
        FreeHEPLookup lookup = app.getLookup();
        lookup.add((Object)this);
        lookup.add((Object)defaultSorter);
        lookup.add((Object)new SorterFolderFirst());
        lookup.add((Object)new SorterAlphabetical());
        lookup.add((Object)new SorterAlphaNumerical());
        this.adapterRegistry = new DefaultFTreeNodeAdapterRegistry(this);
        this.adapterRegistry.registerNodeAdapter(new FTreeFolderNodeAdapter(), FTreeFolderNode.class);
        this.adapterRegistry.registerNodeAdapter(new FTreeLeafNodeAdapter(), FTreeLeafNode.class);
        Template map = new Template();
        map.set("title", "FTree");
        map.set("url", "classpath:/org/freehep/jas/plugin/tree/web/index.html");
        map.set("description", "The JAS3 navigation tree. Different plugins can add/remove/change nodes on the FTree. The FTree also provide a common base through which different plugins can interact with each other");
        lookup.add((Object)map, "built-in-plugins");
        this.fileOpener = (FileOpener)lookup.lookup(FileOpener.class);
        FTreeNodeSorterManager.startListerning();
    }

    ArrayList trees() {
        return new ArrayList(this.trees.values());
    }

    @Override
    public FTreeNodeAdapterRegistry treeNodeAdapterRegistry() {
        return this.adapterRegistry;
    }

    @Override
    public String[] namesOfExistingTrees() {
        Set s = this.trees.keySet();
        String[] tNames = new String[s.size()];
        Iterator iter = s.iterator();
        int count = 0;
        while (iter.hasNext()) {
            tNames[count++] = (String)iter.next();
        }
        return tNames;
    }

    @Override
    public FTree tree() {
        return this.tree("JAS3Tree");
    }

    @Override
    public FTree tree(String name) {
        DefaultFTree tree = (DefaultFTree)this.trees.get(name);
        if (tree != null) {
            return tree;
        }
        tree = new DefaultFTree(new DefaultFTreeNode(name, FTreeFolderNode.class, null));
        ((DefaultFTreeNodeAdapterRegistry)this.adapterRegistry).addCommonAdaptersToTree(tree);
        this.trees.put(name, tree);
        DefaultJTree jTree = new DefaultJTree(tree);
        this.defaultJTrees.put(tree, jTree);
        jTree.setRootVisible(false);
        if (this.fileOpener != null) {
            this.fileOpener.addDropTargetFileOpener(jTree);
        }
        FTreeCellRenderer cellRenderer = new FTreeCellRenderer();
        jTree.setCellRenderer(cellRenderer);
        jTree.setCellEditor(new FTreeTreeCellEditor(jTree, cellRenderer, new FTreeCellEditor(new FTreeNodeTextField(jTree), jTree)));
        jTree.getSelectionModel().setSelectionMode(4);
        jTree.getSelectionModel().addTreeSelectionListener(new FTreeSelectionListener(jTree));
        FTreePane scroll = new FTreePane(jTree);
        scroll.setMinimumSize(new Dimension(100, 100));
        app.getControlManager().openPage((Component)scroll, name, null);
        jTree.addMouseListener(new FTreeMouseListener(jTree));
        DragSource dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = dragSource.createDefaultDragGestureRecognizer(jTree, 0x40000000, new FTreeDragGestureListener(jTree));
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        jTree.setDragEnabled(true);
        jTree.setTransferHandler(new BrokenTransferHandler());
        return tree;
    }

    static FTreePlugin plugin() {
        return thePlugin;
    }

    private void destroyFTree(String name) {
        throw new UnsupportedOperationException("This method has not been implemented yet; please report this to the JAS mailing list");
    }

    @Override
    public int restore(int level, XMLIOManager manager, Element el) {
        switch (level) {
            case 0: {
                return 100;
            }
            case 100: {
                DefaultFTree tree = (DefaultFTree)this.tree();
                DefaultJTree jTree = (DefaultJTree)this.defaultJTrees.get(tree);
                List mainNodes = el.getChildren("mainNode");
                for (int i = 0; i < mainNodes.size(); ++i) {
                    Element mainNodeEl = (Element)mainNodes.get(i);
                    if (mainNodeEl.getAttributeValue("isExpanded") != null) {
                        jTree.setExpandedState(mainNodeEl.getAttributeValue("path"));
                    }
                    List openNodes = mainNodeEl.getChildren("openNode");
                    for (int j = 0; j < openNodes.size(); ++j) {
                        Element openNodeEl = (Element)openNodes.get(j);
                        String path = openNodeEl.getAttributeValue("path");
                        jTree.setExpandedState(path);
                    }
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("Level " + level + " is not supported. Please report this problem!!");
    }

    @Override
    public void save(XMLIOManager manager, Element el) {
        DefaultFTree tree = (DefaultFTree)this.tree();
        Object root = tree.getRoot();
        TreePath rootPath = new TreePath(root);
        int nMainChild = tree.getChildCount(root);
        for (int i = 0; i < nMainChild; ++i) {
            TreePath childPath = rootPath.pathByAddingChild(tree.getChild(root, i));
            Element mainNodeEl = new Element("mainNode");
            mainNodeEl.setAttribute("path", FTreeUtils.createTreePath(childPath).toString());
            DefaultJTree jTree = (DefaultJTree)this.defaultJTrees.get(tree);
            if (jTree.isExpanded(childPath)) {
                mainNodeEl.setAttribute("isExpanded", "true");
                this.saveExpandedChild(tree, jTree, childPath, mainNodeEl);
            }
            el.addContent((Content)mainNodeEl);
        }
    }

    private void saveExpandedChild(DefaultFTree tree, DefaultJTree jTree, TreePath path, Element nodeEl) {
        Object parent = path.getLastPathComponent();
        int nChild = tree.getChildCount(parent);
        for (int i = 0; i < nChild; ++i) {
            TreePath childPath = path.pathByAddingChild(tree.getChild(parent, i));
            if (!jTree.isExpanded(childPath)) continue;
            Element childEl = new Element("openNode");
            childEl.setAttribute("path", FTreeUtils.createTreePath(childPath).toString());
            nodeEl.addContent((Content)childEl);
            this.saveExpandedChild(tree, jTree, childPath, nodeEl);
        }
    }

    @Override
    public boolean apply(JComponent panel) {
        ((FTreePreferencesDialog)panel).apply();
        return true;
    }

    @Override
    public JComponent component() {
        return new FTreePreferencesDialog();
    }

    @Override
    public String[] path() {
        return new String[]{"Navigation Tree"};
    }

    String treeSortingAlgorithm(String treeName) {
        String prop = FTreePLUGIN_TREE_SORTING + treeName;
        return PropertyUtilities.getString((Properties)this.userProperties, (String)prop, (String)defaultSorter.algorithmName());
    }

    void setTreeSortingAlgorithm(String treeName, String sortingAlgorithm) {
        String prop = FTreePLUGIN_TREE_SORTING + treeName;
        this.userProperties.setProperty(prop, sortingAlgorithm);
    }

    boolean isTreeSortingRecursive(String treeName) {
        String prop = FTreePLUGIN_IS_SORTING_RECURSIVE + treeName;
        return PropertyUtilities.getBoolean((Properties)this.userProperties, (String)prop, (boolean)true);
    }

    void setIsTreeSortingRecursive(String treeName, boolean isRecursive) {
        String prop = FTreePLUGIN_IS_SORTING_RECURSIVE + treeName;
        PropertyUtilities.setBoolean((Properties)this.userProperties, (String)prop, (boolean)isRecursive);
    }

    static {
        defaultSorter = new SorterCreationOrder();
        openNonSelectedFolderIcon = ImageHandler.getIcon((String)"images/SelectedOpenFolder.gif", FTreePlugin.class);
        closedNonSelectedFolderIcon = ImageHandler.getIcon((String)"images/SelectedClosedFolder.gif", FTreePlugin.class);
        openSelectedFolderIcon = ImageHandler.getIcon((String)"images/OpenFolder.gif", FTreePlugin.class);
        closedSelectedFolderIcon = ImageHandler.getIcon((String)"images/ClosedFolder.gif", FTreePlugin.class);
        nonSelectedLeafIcon = ImageHandler.getIcon((String)"images/NonSelectedLeafNodeIcon.gif", FTreePlugin.class);
        selectedLeafIcon = ImageHandler.getIcon((String)"images/SelectedLeafIcon.gif", FTreePlugin.class);
    }

    private class FTreeLeafNodeAdapter
    extends DefaultFTreeNodeAdapter {
        FTreeLeafNodeAdapter() {
            super(10);
        }

        @Override
        public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
            if (selected) {
                return selectedLeafIcon;
            }
            return nonSelectedLeafIcon;
        }

        @Override
        public boolean allowsChildren(FTreeNode node, boolean allowsChildren) {
            return false;
        }
    }

    private class FTreeFolderNodeAdapter
    extends DefaultFTreeNodeAdapter {
        FTreeFolderNodeAdapter() {
            super(10);
        }

        @Override
        public Icon icon(FTreeNode node, Icon oldIcon, boolean selected, boolean expanded) {
            oldIcon = selected ? (expanded ? openSelectedFolderIcon : closedSelectedFolderIcon) : (expanded ? openNonSelectedFolderIcon : closedNonSelectedFolderIcon);
            return oldIcon;
        }

        @Override
        public boolean allowsChildren(FTreeNode node, boolean allowsChildren) {
            return true;
        }
    }

    private class BrokenTransferHandler
    extends TransferHandler {
        private BrokenTransferHandler() {
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class FTreeCellRenderer
    extends DefaultTreeCellRenderer {
        FTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(jTree, obj, sel, expanded, leaf, row, hasFocus);
            DefaultFTreeNode node = (DefaultFTreeNode)obj;
            String text = node.name();
            this.setText(text);
            Icon icon = node.icon(sel, expanded);
            if (leaf) {
                this.setLeafIcon(icon);
            } else if (expanded) {
                this.setOpenIcon(icon);
            } else {
                this.setClosedIcon(icon);
            }
            this.setIcon(icon);
            return node.treeCellRendererComponent(this, sel, expanded, leaf, hasFocus);
        }
    }

    private class FTreeNodeTextField
    extends JTextField
    implements ActionListener {
        DefaultJTree jTree;

        FTreeNodeTextField(DefaultJTree jTree) {
            this.addActionListener(this);
            this.jTree = jTree;
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    FTreeNodeTextField.this.jTree.stopEditing();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean retValue;
            String newText = this.getText();
            TreePath nodePath = this.jTree.getLeadSelectionPath();
            DefaultFTreeNode node = (DefaultFTreeNode)nodePath.getLastPathComponent();
            boolean isNodeShowingName = node.isShowingName();
            String oldText = node.name();
            FTreeNodeTextChangeEvent evt = new FTreeNodeTextChangeEvent(node, oldText, newText, isNodeShowingName);
            if (isNodeShowingName) {
                DefaultFTreeNode parentNode;
                DefaultFTreeNode newNode;
                if (newText.equals("")) {
                    return;
                }
                if (!newText.equals(oldText) && (newNode = (parentNode = (DefaultFTreeNode)nodePath.getParentPath().getLastPathComponent()).find(newText)) != null) {
                    return;
                }
            }
            if (!(retValue = this.jTree.model().adapterManager().acceptNewText(evt))) {
                this.getToolkit().beep();
                return;
            }
            if (!this.jTree.model().adapterManager().nodeTextChanged(evt)) {
                ((DefaultFTree)this.jTree.getModel()).treeChanged(new FTreeNodeRenamedNotification(this, node.path(), newText));
            }
        }
    }

    private class FTreeCellEditor
    extends DefaultCellEditor {
        FTreeCellEditor(FTreeNodeTextField textField, DefaultJTree jTree) {
            super(textField);
            this.setClickCountToStart(1);
        }
    }

    private class FTreeTreeCellEditor
    extends DefaultTreeCellEditor {
        private DefaultJTree jTree;

        FTreeTreeCellEditor(DefaultJTree tree, FTreeCellRenderer renderer, FTreeCellEditor editor) {
            super(tree, renderer, editor);
            this.jTree = tree;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        protected void startEditingTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }

        @Override
        protected boolean canEditImmediately(EventObject event) {
            return event == null;
        }

        @Override
        protected boolean inHitRegion(int x, int y) {
            TreePath path = this.jTree.getSelectionPath();
            Rectangle pathBounds = this.jTree.getPathBounds(path);
            y -= pathBounds.y;
            DefaultFTreeNode node = (DefaultFTreeNode)path.getLastPathComponent();
            return (x -= pathBounds.x) > node.icon(this.jTree.isPathSelected(path), this.jTree.isExpanded(path)).getIconWidth();
        }

        @Override
        public boolean isCellEditable(EventObject evtObj) {
            boolean isEditable = super.isCellEditable(evtObj);
            TreePath path = this.jTree.getLeadSelectionPath();
            if (isEditable && path != null) {
                isEditable = ((DefaultFTreeNode)path.getLastPathComponent()).isEditable();
            }
            return isEditable;
        }
    }

    private class FTreeDragGestureListener
    implements DragGestureListener {
        private DefaultJTree jTree;

        FTreeDragGestureListener(DefaultJTree jTree) {
            this.jTree = jTree;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            DefaultFTreeNode[] nodes = this.jTree.selectedNodes();
            if (nodes != null) {
                this.jTree.model().adapterManager().initiateDrag(nodes, dge);
            }
        }
    }

    private class FTreeSelectionListener
    implements TreeSelectionListener {
        private DefaultJTree jTree;

        FTreeSelectionListener(DefaultJTree jTree) {
            this.jTree = jTree;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            String message;
            TreeSelectionModel model = this.jTree.getSelectionModel();
            DefaultFTreeNode[] selectedNodes = null;
            if (this.jTree.getSelectionCount() > 0) {
                TreePath[] p = model.getSelectionPaths();
                DefaultFTreeNode[] nodes = new DefaultFTreeNode[p.length];
                int start = 0;
                int end = p.length;
                if (e.getNewLeadSelectionPath().equals(e.getOldLeadSelectionPath())) {
                    start = 1 - end;
                    end = 1;
                }
                for (int i = start; i < end; ++i) {
                    int index = Math.abs(i);
                    nodes[index] = (DefaultFTreeNode)p[index].getLastPathComponent();
                }
                selectedNodes = nodes;
            }
            this.jTree.setSelectedNodes(selectedNodes);
            DefaultFTreeNode node = (DefaultFTreeNode)e.getPath().getLastPathComponent();
            this.jTree.model().adapterManager().selectionChanged(node, e, model);
            if (e.isAddedPath() && (message = this.jTree.model().adapterManager().statusMessage(node)) != null) {
                app.setStatusMessage(message);
            }
            HashSet<CommandProcessor> newCommandProcessors = new HashSet<CommandProcessor>();
            newCommandProcessors.add(this.jTree.commandProcessor());
            FTreeNode[] nodeSel = this.jTree.selectedNodes();
            if (nodeSel != null && nodeSel.length > 0) {
                this.jTree.model().adapterManager().commandProcessors(nodeSel, newCommandProcessors);
            }
            CommandTargetManager ctm = app.getCommandTargetManager();
            for (CommandProcessor cp : newCommandProcessors) {
                if (FTreePlugin.this.oldCommandProcessors.contains(cp)) continue;
                ctm.add((CommandGroup)cp);
            }
            for (CommandProcessor cp : FTreePlugin.this.oldCommandProcessors) {
                if (newCommandProcessors.contains(cp)) continue;
                ctm.remove((CommandGroup)cp);
            }
            FTreePlugin.this.oldCommandProcessors = newCommandProcessors;
        }
    }

    private class FTreeMouseListener
    extends MouseAdapter {
        private DefaultJTree jTree;

        FTreeMouseListener(DefaultJTree jTree) {
            this.jTree = jTree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DefaultFTreeNode node = null;
            TreePath path = this.jTree.getSelectionPath();
            Rectangle pathBounds = this.jTree.getPathBounds(path);
            if (pathBounds != null && pathBounds.contains(e.getPoint())) {
                node = (DefaultFTreeNode)path.getLastPathComponent();
            }
            if (e.getClickCount() == 2) {
                if (this.jTree.getSelectionCount() == 0) {
                    return;
                }
                if (this.jTree.getSelectionCount() != 1) {
                    throw new RuntimeException("Unexpected number of selected nodes. Please report this problem!");
                }
                if (node != null) {
                    this.jTree.model().adapterManager().doubleClick(node);
                }
            } else if (e.getClickCount() == 1) {
                if (e.getButton() == 1 && node != null) {
                    e.translatePoint(-pathBounds.x, -pathBounds.y);
                    this.jTree.model().adapterManager().mouseClicked(node, e, pathBounds.getSize());
                }
            }
        }
    }

    private class FTreePane
    extends JScrollPane
    implements ManagedPage {
        FTreePane(JTree jTree) {
            super(jTree);
        }

        public boolean close() {
            return false;
        }

        public void pageClosed() {
        }

        public void pageDeiconized() {
        }

        public void pageDeselected() {
        }

        public void pageIconized() {
        }

        public void pageSelected() {
        }

        public void setPageContext(PageContext context) {
        }
    }
}

