/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeListener;
import org.freehep.swing.popup.GlobalMouseListener;
import org.freehep.swing.popup.GlobalPopupListener;
import plotter.Axis;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.PaintedPanel;
import plotter.PlotLayout;
import plotter.SinOverlay;

public class SinTest {
    public static void main(String[] args) {
        SimpleContinuousAxisModel xModel = new SimpleContinuousAxisModel(-10.0, 10.0);
        SimpleContinuousAxisModel yModel = new SimpleContinuousAxisModel(-1.1, 1.1);
        Axis bottomAxis = new Axis(xModel, Axis.AxisPosition.BOTTOM);
        Axis leftAxis = new Axis(yModel, Axis.AxisPosition.LEFT);
        SinOverlay overlay = new SinOverlay("sin(x)", bottomAxis, leftAxis);
        DataArea da = new DataArea(bottomAxis, leftAxis);
        da.add(overlay);
        PaintedPanel plotPanel = new PaintedPanel(new PlotLayout());
        plotPanel.add((Component)bottomAxis, "South");
        plotPanel.add((Component)leftAxis, "West");
        plotPanel.add((Component)da, "Center");
        JFrame frame = new JFrame("AIDATest");
        frame.getToolkit().setDynamicLayout(true);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)plotPanel, "Center");
        GlobalMouseListener ml = new GlobalMouseListener((Component)frame.getContentPane());
        ml.addMouseListener((MouseListener)new GlobalPopupListener());
        frame.pack();
        frame.show();
    }

    private static class SimpleContinuousAxisModel
    implements ContinuousAxisModel {
        private double min;
        private double max;

        SimpleContinuousAxisModel(double min, double max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public double getAxisCoordinateFromModelCoordinate(double param) {
            if (param < this.min || param > this.max) {
                throw new IllegalArgumentException();
            }
            return (param - this.min) / (this.max - this.min);
        }

        @Override
        public double getModelCoordinateFromAxisCoordinate(double param) {
            if (param < 0.0 || param > 1.0) {
                throw new IllegalArgumentException();
            }
            return this.min + param * (this.max - this.min);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }
}

