/*
 * Decompiled with CFR 0.152.
 */
package menus;

import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import menus.ObjectSelectionModel;

public class EnumMenu
extends JMenu {
    private ObjectSelectionModel objectModel;

    public <T extends Enum> EnumMenu(String name, ObjectSelectionModel<T> model, Class<T> enumeration) {
        super(name);
        this.objectModel = model;
        for (Enum e : (Enum[])enumeration.getEnumConstants()) {
            this.add(new EnumItem(e));
        }
    }

    public EnumMenu(String name, ObjectSelectionModel model, Object[] values, String[] vNames) {
        super(name);
        this.objectModel = model;
        for (int i = 0; i < values.length; ++i) {
            this.add(new ObjectEnumItem(vNames[i], values[i]));
        }
    }

    private static String capitalize(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1).toLowerCase();
    }

    private class ObjectEnumItem
    extends JRadioButtonMenuItem {
        private Object value;

        ObjectEnumItem(String name, Object value) {
            super(name);
            this.value = value;
            this.setSelected(value == EnumMenu.this.objectModel.getValue());
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            EnumMenu.this.objectModel.setValue(this.value);
        }
    }

    private class EnumItem
    extends JRadioButtonMenuItem {
        private Enum value;

        EnumItem(Enum value) {
            super(EnumMenu.capitalize(value.toString()));
            this.value = value;
            this.setSelected(value == EnumMenu.this.objectModel.getValue());
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            EnumMenu.this.objectModel.setValue(this.value);
        }
    }
}

