/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import plotter.AbstractAxisModel;
import plotter.ContinuousAxisModel;

public class LinearAxisModel
extends AbstractAxisModel
implements ContinuousAxisModel {
    private double min;
    private double max;

    public LinearAxisModel(double min, double max) {
        this.setRange(min, max);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        if (this.max != max) {
            this.setRange(this.min, max);
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        if (this.min != min) {
            this.setRange(min, this.max);
        }
    }

    public void setRange(double min, double max) {
        if (this.min != min || this.max != max) {
            if (min >= max) {
                max = min + 1.0;
            }
            this.min = min;
            this.max = max;
            this.fireAxisChanged();
        }
    }

    @Override
    public double getAxisCoordinateFromModelCoordinate(double param) {
        return (param - this.min) / (this.max - this.min);
    }

    @Override
    public double getModelCoordinateFromAxisCoordinate(double param) {
        return this.min + param * (this.max - this.min);
    }
}

