/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plotter.AxisLabeler;
import plotter.BasicAxisLabeler;
import plotter.ContinuousAxisModel;
import plotter.DiscreteAxisModel;
import plotter.LabelSizer;
import plotter.LinearAxisModel;

public class DefaultAxisLabeller
implements AxisLabeler,
ChangeListener {
    private BasicAxisLabeler labeler;
    private ContinuousAxisModel model;
    private static final String times10tothepower = "\u00d710^";

    public DefaultAxisLabeller(ContinuousAxisModel model, LabelSizer labelSizer) {
        this.model = model;
        this.labeler = new BasicAxisLabeler(model.getModelCoordinateFromAxisCoordinate(0.0), model.getModelCoordinateFromAxisCoordinate(1.0), labelSizer);
        labelSizer.addChangeListener(this);
        model.addChangeListener(this);
    }

    @Override
    public String getLabel(int index) {
        return this.labeler.getLabel(index);
    }

    @Override
    public float getLabelPos(int index) {
        return this.labeler.getLabelPosition(index);
    }

    @Override
    public float getMinorTickPos(int index) {
        return this.labeler.getMinorTickPos(index);
    }

    @Override
    public int getNLabels() {
        return this.labeler.getNLabels();
    }

    @Override
    public int getNMinorTickMarks() {
        return this.labeler.getNMinorTickMarks();
    }

    @Override
    public int getNTickMarks() {
        return this.labeler.getNLabels();
    }

    @Override
    public float getTickPos(int index) {
        return this.labeler.getLabelPosition(index);
    }

    @Override
    public String getToolTipText(float pos) {
        String tip = this.labeler.getToolTipText(pos);
        if (this.model instanceof DiscreteAxisModel) {
            DiscreteAxisModel discrete = (DiscreteAxisModel)((Object)this.model);
            int bin = discrete.getBinFromAxisCoordinate(pos);
            tip = tip + " (" + discrete.getBinName(bin) + ")";
        }
        return tip;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.labeler.setRange(this.model.getModelCoordinateFromAxisCoordinate(0.0), this.model.getModelCoordinateFromAxisCoordinate(1.0));
    }

    @Override
    public String getAxisUnit() {
        int pow = this.labeler.getPower();
        return pow == 0 ? null : times10tothepower + this.labeler.getPower();
    }

    public static void main(String[] args) {
        LinearAxisModel model = new LinearAxisModel(1.27318846703E12, 1.27318868903E12);
        LabelSizer sizer = new LabelSizer(){

            @Override
            public float getSize(String xxx) {
                return 0.03f;
            }

            @Override
            public void addChangeListener(ChangeListener l) {
            }

            @Override
            public void removeChangeListener(ChangeListener l) {
            }
        };
        DefaultAxisLabeller labeler = new DefaultAxisLabeller(model, sizer);
        System.out.println(labeler.getNLabels());
        for (int i = 0; i < labeler.getNLabels(); ++i) {
            System.out.println(labeler.getLabelPos(i));
        }
    }
}

