/*
 * Decompiled with CFR 0.152.
 */
package menus;

import java.awt.Color;
import java.awt.Component;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import menus.BooleanMenu;
import menus.ColorMenu;
import menus.DescriptorModel;
import menus.EnumMenu;
import menus.IncludeInMenu;
import menus.IntegerMenu;
import menus.MaxValue;
import menus.MinValue;
import menus.StringMenu;

public class MenuUtils {
    public static void buildMenu(JPopupMenu menu, Object bean) {
        try {
            PropertyDescriptor[] descs;
            for (PropertyDescriptor pd : descs = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                IncludeInMenu item;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null || (item = writeMethod.getAnnotation(IncludeInMenu.class)) == null) continue;
                String title = item.value();
                Class<?> itemClass = pd.getPropertyType();
                DescriptorModel<Boolean> vm = new DescriptorModel<Boolean>(bean, pd);
                if (Enum.class.isAssignableFrom(itemClass)) {
                    menu.add(new EnumMenu(title, vm, itemClass));
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(itemClass)) {
                    menu.add(new BooleanMenu(title, vm));
                    continue;
                }
                if (Color.class.isAssignableFrom(itemClass)) {
                    menu.add(new ColorMenu(title, vm, true));
                    continue;
                }
                if (String.class.isAssignableFrom(itemClass)) {
                    menu.add(new StringMenu(title + "...", vm));
                    continue;
                }
                if (!Integer.TYPE.isAssignableFrom(itemClass)) continue;
                MinValue min = writeMethod.getAnnotation(MinValue.class);
                MaxValue max = writeMethod.getAnnotation(MaxValue.class);
                menu.add(new IntegerMenu(title + "...", vm, min != null ? min.value() : 0, max != null ? max.value() : 100));
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("Unexpected error building menu", ex);
        }
    }

    static Component getInvoker(JMenuItem item) {
        JPopupMenu parent = (JPopupMenu)SwingUtilities.getAncestorOfClass(JPopupMenu.class, item);
        parent = MenuUtils.getRootPopupMenu(parent);
        return parent.getInvoker();
    }

    static JPopupMenu getRootPopupMenu(JPopupMenu popup) {
        JPopupMenu mp = popup;
        while (mp != null && !MenuUtils.isPopupMenu(mp) && mp.getInvoker() != null && mp.getInvoker().getParent() != null && mp.getInvoker().getParent() instanceof JPopupMenu) {
            mp = (JPopupMenu)mp.getInvoker().getParent();
        }
        return mp;
    }

    private static boolean isPopupMenu(JPopupMenu popup) {
        return popup.getInvoker() != null && !(popup.getInvoker() instanceof JMenu);
    }
}

