/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;

public class CommandHelper {
    private boolean preconditionsMet = true;
    private boolean enterFaultOnError = false;
    private String preconditionsReason = "Preconditions not met";
    private final Agent agent;
    private Duration duration;
    private boolean nestedInvocation = false;
    private final AgentStateService agentStateService;

    public CommandHelper(Agent agent) {
        this.agent = agent;
        this.agentStateService = agent.getAgentService(AgentStateService.class);
    }

    public CommandHelper precondition(boolean ok) {
        this.preconditionsMet &= ok;
        return this;
    }

    public CommandHelper precondition(boolean ok, String reason, Object ... args) {
        if (this.preconditionsMet && !ok) {
            this.preconditionsMet = false;
            this.preconditionsReason = args.length > 0 ? String.format(reason, args) : reason;
        }
        return this;
    }

    public CommandHelper precondition(boolean ok, String reason, Supplier<Object> ... args) {
        if (this.preconditionsMet && !ok) {
            this.preconditionsMet = false;
            if (args.length > 0) {
                Object[] a = new Object[args.length];
                int count = 0;
                for (Supplier<Object> s : args) {
                    a[count++] = s.get();
                }
                this.preconditionsReason = String.format(reason, a);
            } else {
                this.preconditionsReason = reason;
            }
        }
        return this;
    }

    public CommandHelper precondition(Enum ... states) {
        StateBundle stateBundle = this.agentStateService.getState();
        for (Enum state : states) {
            if (!stateBundle.isInState(state)) continue;
            return this;
        }
        this.preconditionsMet = false;
        this.preconditionsReason = "Command not accepted in state " + stateBundle;
        return this;
    }

    public CommandHelper duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public CommandHelper duration(Supplier<Duration> durationSupplier) {
        if (this.preconditionsMet) {
            this.duration = durationSupplier.get();
        }
        return this;
    }

    public CommandHelper enterFaultOnException(boolean enterFault) {
        this.enterFaultOnError = enterFault;
        return this;
    }

    public <T> T action(Callable<T> callable) {
        if (this.handlePreconditions()) {
            this.nestedInvocation = true;
            try {
                return callable.call();
            }
            catch (Exception x) {
                throw this.handleException(x);
            }
        }
        return null;
    }

    public void action(RunnableWithException runnable) {
        if (this.handlePreconditions()) {
            this.nestedInvocation = true;
            try {
                runnable.run();
            }
            catch (Exception x) {
                throw this.handleException(x);
            }
        }
    }

    private boolean handlePreconditions() {
        if (!this.preconditionsMet) {
            if (!this.agent.isExternalCommandInvocation() || this.nestedInvocation) {
                throw new RuntimeException(this.preconditionsReason);
            }
            this.agent.sendNack((Serializable)((Object)this.preconditionsReason));
        } else if (this.duration != null && this.agent.isExternalCommandInvocation()) {
            this.agent.sendAck(this.duration);
        }
        return this.preconditionsMet;
    }

    private CommandFailedException handleException(Exception x) {
        String exceptionReason = this.getExceptionReason(x);
        if (this.enterFaultOnError) {
            this.agent.getAgentService(AlertService.class).raiseAlert(InfrastructureAlert.COMMAND_EXECUTION_FAILURE.getAlert(), AlertState.ALARM, "Execution of command \"" + this.agent.getCurrentRunningCommandName() + "\" failed unexpectedly due to: " + exceptionReason);
            return new CommandFailedException("Exception while executing command, fault state entered: " + exceptionReason, x);
        }
        return new CommandFailedException("Unexpected exception during command execution: " + exceptionReason, x);
    }

    private String getExceptionReason(Exception x) {
        Object reason = x.getMessage();
        if (reason == null || ((String)reason).isEmpty()) {
            reason = "(no reason provided by exception of type " + x.getClass().getSimpleName() + ")";
        }
        return reason;
    }

    public static class CommandFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -809673339005572968L;

        public CommandFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

