/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;

class BiasesConfigPanel
extends JPanel {
    private static final Insets INSETS_STD = new Insets(4, 4, 4, 4);
    private static final int TF_WIDTH = 50;
    private static final int TF_WIDTH_L = 80;
    private final NumberFormatter fmt = new NumberFormatter();
    private final JLabel[] lbBiases = new JLabel[6];
    private final JFormattedTextField[] tfBiases = new JFormattedTextField[6];
    private final int iBias;
    private final BiasDACS bias;
    private final boolean raw;
    private final Map biasNames;
    private final List<Integer> biasList;
    private static final Map<Integer, String> biasNamesP = new LinkedHashMap<Integer, String>();
    private static final List<Integer> biasListP;
    private static final Map<Integer, String> biasNamesR;
    private static final List<Integer> biasListR;
    private static final long serialVersionUID = 1L;

    BiasesConfigPanel(int ia, BiasDACS a, boolean r) {
        this.iBias = ia;
        this.bias = a;
        this.raw = r;
        this.fmt.setFormat(new DecimalFormat(this.raw ? "####0" : "##0.0#"));
        this.fmt.setValueClass(this.raw ? Integer.class : Double.class);
        JFormattedTextField tf = new JFormattedTextField(this.fmt);
        Dimension d5 = tf.getPreferredSize();
        d5.width = 50;
        this.biasList = this.raw ? biasListR : biasListP;
        this.biasNames = this.raw ? biasNamesR : biasNamesP;
        for (int bnum : this.biasList) {
            this.lbBiases[bnum] = new JLabel(this.biasNames.get(bnum) + ":");
            this.tfBiases[bnum] = new JFormattedTextField(this.fmt);
            this.tfBiases[bnum].setPreferredSize(d5);
            this.tfBiases[bnum].setMinimumSize(d5);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = INSETS_STD;
        String title = "Bias DAC " + this.iBias;
        this.setBorder(BorderFactory.createTitledBorder(title));
        gbc.anchor = 18;
        gbc.insets = INSETS_STD;
        int fld = 0;
        for (int bnum : this.biasList) {
            gbc.gridx = 2 * (fld & 1);
            gbc.gridy += 1 - (fld & 1);
            this.add((Component)this.lbBiases[bnum], gbc);
            ++gbc.gridx;
            this.add((Component)this.tfBiases[bnum], gbc);
            ++fld;
        }
    }

    void save() {
        if (this.raw) {
            int[] values = this.bias.getValues();
            for (int bnum : this.biasList) {
                values[bnum] = (Integer)this.tfBiases[bnum].getValue();
            }
        } else {
            double[] values = this.bias.getPValues();
            for (int bnum : this.biasList) {
                values[bnum] = (Double)this.tfBiases[bnum].getValue();
            }
        }
    }

    void read() {
        if (this.raw) {
            int[] values = this.bias.getValues();
            for (int bnum : this.biasList) {
                this.tfBiases[bnum].setValue(values[bnum]);
            }
        } else {
            double[] values = this.bias.getPValues();
            for (int bnum : this.biasList) {
                this.tfBiases[bnum].setValue(values[bnum]);
            }
        }
    }

    static {
        biasNamesP.put(0, "GD");
        biasNamesP.put(5, "RD");
        biasNamesP.put(2, "OG");
        biasNamesP.put(1, "OD");
        biasNamesP.put(4, "CS Gate");
        biasListP = new ArrayList<Integer>(biasNamesP.keySet());
        biasNamesR = new LinkedHashMap<Integer, String>();
        biasNamesR.put(0, "GD");
        biasNamesR.put(5, "RD");
        biasNamesR.put(2, "OG");
        biasNamesR.put(3, "OG Shift");
        biasNamesR.put(1, "OD");
        biasNamesR.put(4, "CS Gate");
        biasListR = new ArrayList<Integer>(biasNamesR.keySet());
    }
}

