/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.GroupView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;

public class ComboGroupView
extends GroupView {
    public static final String CREATOR_PATH = "Built-In/Grouped/Combo";
    private JPanel root;
    private Box comboPanel;
    private ArrayList<JComboBox<String>> combos;
    private JScrollPane viewsPane;
    private boolean adjusting;

    @Create(category="MonitorView", name="Group Combo", path="Built-In/Grouped/Combo", description="Monitoring data view that divides channels into groups, and displays one group at a time. Combo boxes are used to select the group to display, and tree views are used for each group.")
    public ComboGroupView(@Par(def="1", desc="Depth of group hierarchy (number of combo boxes, maximum 6). If 0, the display path is expected in \"group/.../name//rest/of/.../path\" format, and the depth is determined by the number of slash-separated segments in \"group/.../name\". If positive N, the fist N segments of the display path ware used as a group name.") int depth, @Par(def="_null_", desc="List of labels for combo boxes. If not specified, no labels are used.") List<String> labels) {
        this.descriptor = new Descriptor();
        this.descriptor.setName("Group Combo");
        if (depth < 0 || depth > 6) {
            throw new IllegalArgumentException("Illegal group tree depth, must be between 0 and 6.");
        }
        this.descriptor.setDepth(depth);
        if (labels != null && !labels.isEmpty()) {
            ((Descriptor)this.descriptor).setLabels(labels.toArray(new String[0]));
        }
    }

    @Override
    public JComponent getPanel() {
        if (this.root == null) {
            this.root = new JPanel(new BorderLayout());
            this.comboPanel = Box.createHorizontalBox();
            this.root.add((Component)this.comboPanel, "North");
            this.comboPanel.add(Box.createRigidArea(Const.HDIM));
            this.combos = new ArrayList(this.depth);
            this.depthChanged();
            this.comboPanel.add(Box.createHorizontalGlue());
            this.viewsPane = new JScrollPane();
            this.root.add((Component)this.viewsPane, "Center");
            this.selectGroup(null);
        }
        return this.root;
    }

    @Override
    protected void selectGroup(String group) {
        if (this.root == null) {
            return;
        }
        super.selectGroup(group);
    }

    @Override
    protected void groupsAdded(List<String> groups) {
        if (this.root == null) {
            return;
        }
        this.depthChanged();
        this.selectGroup(this.currentGroup);
    }

    @Override
    protected void groupsRemoved(List<String> groups) {
        if (this.root == null) {
            return;
        }
        this.depthChanged();
        this.selectGroup(this.currentGroup);
    }

    private void depthChanged() {
        block2: {
            int oldDepth;
            block3: {
                if (this.root == null) break block2;
                oldDepth = this.combos.size();
                if (this.depth <= oldDepth) break block3;
                for (int level = oldDepth; level < this.depth; ++level) {
                    JComboBox cb = new JComboBox();
                    cb.setEnabled(false);
                    int lev = level;
                    cb.addActionListener(e -> this.comboBoxAction(lev, (String)cb.getSelectedItem()));
                    this.combos.add(cb);
                    int index = 2 * level;
                    String[] labels = this.getDescriptor().getLabels();
                    JLabel label = new JLabel((String)(labels != null && labels.length > level ? " " + labels[level] + " " : "  "));
                    this.comboPanel.add((Component)label, ++index);
                    this.comboPanel.add((Component)cb, ++index);
                }
                break block2;
            }
            if (this.depth >= oldDepth) break block2;
            int level = oldDepth;
            while (level > this.depth) {
                this.combos.remove(--level);
                int index = 2 * level + 1;
                this.comboPanel.remove(index);
                this.comboPanel.remove(index);
            }
        }
    }

    @Override
    protected void groupSelected() {
        this.adjusting = true;
        if (Objects.equals(this.currentGroup, "")) {
            this.combos.forEach((Consumer<JComboBox<String>>)((Consumer<JComboBox>)cb -> {
                cb.removeAllItems();
                cb.setSelectedItem(null);
                cb.setEnabled(false);
            }));
            this.viewsPane.setViewportView(new MonitorDisplay.EMPTY());
        } else {
            int i;
            String[] gg = this.getPath(this.currentGroup);
            String g = null;
            for (i = 0; i < gg.length; ++i) {
                this.combos.get(i).setModel(new DefaultComboBoxModel<String>(this.getSubgroups(g)));
                this.combos.get(i).setSelectedItem(gg[i]);
                this.combos.get(i).setEnabled(true);
                g = g == null ? gg[i] : g + "/" + gg[i];
            }
            if (gg.length < this.depth) {
                String[] sg = this.getSubgroups(g);
                if (sg.length == 0) {
                    this.combos.get(gg.length).removeAllItems();
                    this.combos.get(gg.length).setSelectedItem(null);
                    this.combos.get(gg.length).setEnabled(false);
                } else {
                    this.combos.get(gg.length).setModel(new DefaultComboBoxModel<String>(sg));
                    this.combos.get(gg.length).setSelectedItem("");
                    this.combos.get(gg.length).setEnabled(true);
                }
            }
            for (i = gg.length + 1; i < this.depth; ++i) {
                this.combos.get(i).removeAllItems();
                this.combos.get(i).setSelectedItem(null);
                this.combos.get(i).setEnabled(false);
            }
            AbstractMonitorView view = this.getView(this.currentGroup);
            JComponent panel = view.getPanel();
            this.viewsPane.setViewportView(panel);
        }
        this.adjusting = false;
    }

    private void comboBoxAction(int level, String groupSegment) {
        if (this.adjusting) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append((String)this.combos.get(i).getSelectedItem()).append("/");
        }
        sb.append(groupSegment);
        this.selectGroup(sb.toString());
    }

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public static class Descriptor
    extends GroupView.Descriptor {
        private String[] labels;

        public String[] getLabels() {
            return this.labels;
        }

        public void setLabels(String[] labels) {
            this.labels = labels;
        }

        @Override
        public Descriptor clone() {
            return (Descriptor)super.clone();
        }
    }
}

