/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.Options;
import org.lsst.ccs.bootstrap.Bootstrap;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.ResourceDirectory;
import org.lsst.ccs.bootstrap.ResourcesTree;
import org.lsst.ccs.bootstrap.ResourcesTreeProperties;
import org.lsst.ccs.bootstrap.ResourcesUtils;

public abstract class BootstrapResourceUtils {
    private static final Logger logger = Logger.getLogger("org.lsst.ccs.bootstrap");

    public static List<String>[] separateArgumentsForOptions(String[] args, Options options) {
        ArrayList[] result = new ArrayList[2];
        ArrayList<String> argumentsToParse = new ArrayList<String>();
        ArrayList<String> argumentsLeftOver = new ArrayList<String>();
        boolean skipNext = false;
        for (int i = 0; i < args.length; ++i) {
            if (skipNext) {
                skipNext = false;
                continue;
            }
            String arg = args[i];
            if (arg.startsWith("-D")) {
                int propertyStrIndex = arg.equals("-D") ? i + 1 : i;
                String propertyStr = args[propertyStrIndex].replace("-D", "");
                if (!propertyStr.contains("=")) {
                    args[propertyStrIndex] = args[propertyStrIndex].replace(propertyStr, propertyStr + "=");
                }
                if (arg.equals("-D")) {
                    argumentsToParse.add(arg);
                    continue;
                }
                argumentsLeftOver.add(args[i]);
                continue;
            }
            if (arg.startsWith("-") && !options.hasOption(arg)) {
                String tmpArg;
                argumentsLeftOver.add(arg);
                if (i >= args.length - 1 || (tmpArg = args[i + 1]).startsWith("-")) continue;
                argumentsLeftOver.add(tmpArg);
                skipNext = true;
                continue;
            }
            argumentsToParse.add(arg);
            argumentsLeftOver.add(arg);
        }
        result[0] = new ArrayList(argumentsToParse);
        result[1] = new ArrayList(argumentsLeftOver);
        return result;
    }

    public static Properties getBootstrapSystemProperties() {
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Getting Bootstrap System Properties");
        }
        return BootstrapResourceUtils.buildBootstrapProperties(null, null, true);
    }

    public static String getPathOfPropertiesFileInUserResourceDirectories(String propertyFileName) {
        if (!((String)propertyFileName).endsWith(".properties")) {
            propertyFileName = (String)propertyFileName + ".properties";
        }
        return BootstrapResourceUtils.getPathOfResourceInUserResourceDirectories((String)propertyFileName);
    }

    public static String getPathOfResourceInUserResourceDirectories(String fullFileName) {
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            Path filePath;
            ResourceDirectory resourceDir = resourceDirs.next();
            if (resourceDir.isDistributionDir() || !resourceDir.supportsExtension(BootstrapResourceUtils.getResourceExtension(fullFileName)) || (filePath = ResourcesUtils.getNormalizedPathIfExistsInResourceDirectories(resourceDir.getResouceDirectoryPath(), fullFileName, tree.getResourceDirectoryList())) == null || !Files.exists(filePath, new LinkOption[0])) continue;
            return filePath.toString();
        }
        return null;
    }

    static String getResourceExtension(String resourceName) {
        String extension = null;
        if (resourceName.contains(".")) {
            extension = resourceName.substring(resourceName.lastIndexOf(".") + 1);
        }
        return extension;
    }

    public static URI getResourceURI(String resourceName) throws MalformedURLException {
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            Path p;
            ResourceDirectory resourceDir = resourceDirs.next();
            if (!resourceDir.supportsExtension(BootstrapResourceUtils.getResourceExtension(resourceName)) || (p = ResourcesUtils.getNormalizedPathIfExistsInResourceDirectories(resourceDir.getResouceDirectoryPath(), resourceName, tree.getResourceDirectoryList())) == null || !Files.exists(p, new LinkOption[0])) continue;
            return resourceDir.getResourceURI(resourceName);
        }
        return null;
    }

    public static URL getResourceURL(String resourceName) throws MalformedURLException {
        URL url;
        URI uri = BootstrapResourceUtils.getResourceURI((String)resourceName);
        if (uri != null) {
            return uri.toURL();
        }
        if (!((String)resourceName).startsWith("/")) {
            resourceName = "/" + (String)resourceName;
        }
        if ((url = BootstrapUtils.class.getResource((String)resourceName)) != null) {
            logger.fine("Found resource loacation " + url);
            return url;
        }
        return null;
    }

    public static String getTopUserResourceDirectory() {
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        ListIterator<ResourceDirectory> resourceDirs = tree.getResourceDirectoryList().listIterator();
        while (resourceDirs.hasNext()) {
            ResourceDirectory resourceDir = resourceDirs.next();
            if (resourceDir.isDistributionDir()) continue;
            Object fullPath = resourceDir.getResouceDirectoryPath().toString();
            if (!((String)fullPath).endsWith("/")) {
                fullPath = (String)fullPath + "/";
            }
            return fullPath;
        }
        return null;
    }

    public static Properties getBootstrapProperties(String fileName, Class clazz) {
        if (!((String)fileName).endsWith(".properties")) {
            fileName = (String)fileName + ".properties";
        }
        if (clazz == null) {
            clazz = Bootstrap.getLoaderClass();
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for Properties " + (String)fileName);
        }
        InputStream in = BootstrapResourceUtils.getResourceFromClassPath(clazz, (String)fileName);
        return BootstrapResourceUtils.buildBootstrapProperties(in, (String)fileName, false);
    }

    public static Properties getBootstrapProperties(String fileName) {
        return BootstrapResourceUtils.getBootstrapProperties(fileName, Bootstrap.getLoaderClass());
    }

    private static Properties buildBootstrapProperties(InputStream in, String fileName, boolean includeSystem) {
        ResourcesTreeProperties props = null;
        if (in != null && fileName != null) {
            props = new ResourcesTreeProperties("ClassPath " + fileName, null, null);
            try {
                props.load(in);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Problem loading properties from classpath", ioe);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not close stream.", ioe);
                }
            }
        }
        String applicationLevel = Bootstrap.getBootstrapApplication();
        String topicLevel = fileName;
        Properties appProperties = new Properties();
        if (applicationLevel != null) {
            appProperties = ResourcesUtils.getApplicationDefinitionFile(BootstrapUtils.getBootstrapResourcesTree(), applicationLevel);
        }
        try {
            InputStream is = BootstrapResourceUtils.getBootstrapResource(applicationLevel + ".app");
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] extensions = appProperties.getProperty("org.lsst.ccs.application.extends", "").split(",");
        ArrayList<String> appsToLoad = new ArrayList<String>();
        ArrayList<String> extensionsToLoad = new ArrayList<String>();
        for (String extension : extensions) {
            appsToLoad.add(extension.trim());
            extensionsToLoad.add("app");
        }
        Collections.reverse(appsToLoad);
        if (topicLevel != null) {
            appsToLoad.add(topicLevel);
            extensionsToLoad.add("properties");
        }
        appsToLoad.add("ccsGlobal");
        extensionsToLoad.add("properties");
        if (applicationLevel != null) {
            appsToLoad.add(applicationLevel);
            extensionsToLoad.add("app");
        }
        props = (ResourcesTreeProperties)ResourcesUtils.getMergedProperties(BootstrapUtils.getBootstrapResourcesTree(), appsToLoad.toArray(new String[0]), includeSystem, props, extensionsToLoad.toArray(new String[0]));
        if (!Bootstrap.getCmdLineProperties().isEmpty()) {
            if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
                System.out.println("*** Adding command line properties to properties chain.");
            }
            ResourcesTreeProperties cmdLinePros = new ResourcesTreeProperties("Command Line Properties", null, props);
            cmdLinePros.putAll((Map<?, ?>)Bootstrap.getCmdLineProperties());
            props = cmdLinePros;
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            ResourcesUtils.printProperties(props);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("** Found properties " + fileName);
        ResourcesUtils.printProperties(props, sb, logger);
        return props;
    }

    public static InputStream getBootstrapPropertiesInputStream(String fileName, Class clazz) {
        Properties props = BootstrapResourceUtils.getBootstrapProperties(fileName, clazz);
        if (props == null) {
            return null;
        }
        Properties outProps = props;
        if (props instanceof ResourcesTreeProperties) {
            outProps = new Properties();
            ((ResourcesTreeProperties)props).copyProperties(outProps);
        }
        ByteArrayInputStream is = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            outProps.store(output, null);
            is = new ByteArrayInputStream(output.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return is;
    }

    public static InputStream getBootstrapResource(String resourceName, Class clazz) {
        if (clazz == null) {
            clazz = Bootstrap.getLoaderClass();
        }
        if (Bootstrap.verbose() && !Bootstrap.isQuiet()) {
            System.out.println("*** Looking for resource " + resourceName + " for Class " + clazz);
        }
        InputStream in = null;
        try {
            in = ResourcesUtils.getResourceFromResourceTree(BootstrapUtils.getBootstrapResourcesTree(), resourceName, logger);
        }
        catch (Exception fnfe) {
            throw new RuntimeException(fnfe);
        }
        if (in != null) {
            return in;
        }
        return BootstrapResourceUtils.getResourceFromClassPath(clazz, resourceName);
    }

    public static InputStream getBootstrapResource(String resourceName) {
        return BootstrapResourceUtils.getBootstrapResource(resourceName, Bootstrap.getLoaderClass());
    }

    public static Set<Object> getAllKeysInProperties(Properties props) {
        LinkedHashSet<Object> keySet = new LinkedHashSet<Object>();
        if (props != null) {
            ResourcesUtils.loadKeySetForProperties(props, keySet);
        }
        return keySet;
    }

    public static List<String> getOrderedListOfResourceDirectories() {
        return BootstrapUtils.getOrderedListOfResourceDirectories();
    }

    private static InputStream getResourceFromClassPath(Class clazz, String resourceName) {
        InputStream in = clazz.getResourceAsStream((String)resourceName);
        if (in == null && !((String)resourceName).startsWith("/")) {
            resourceName = "/" + (String)resourceName;
            in = clazz.getResourceAsStream((String)resourceName);
        }
        if (Bootstrap.verbose() && in != null && !Bootstrap.isQuiet()) {
            System.out.println("*** Found resource " + (String)resourceName + " in classpath for Class " + clazz);
        }
        if (in != null) {
            logger.fine("Found resource " + (String)resourceName + " from classpath");
        }
        return in;
    }

    public static Set<String> findMatchingResources(String pattern) {
        HashSet<String> result = new HashSet<String>();
        Pattern p = Pattern.compile(pattern);
        ResourcesTree tree = BootstrapUtils.getBootstrapResourcesTree();
        for (ResourceDirectory dir : tree.getResourceDirectoryList()) {
            if (!dir.exists()) continue;
            for (String fileName : dir.findMatchingResources(p)) {
                result.add(fileName);
            }
        }
        return result;
    }

    public static Properties getManifestVersionsForClass(Class clazz) {
        try {
            URL classUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
            File f = new File(classUrl.toURI());
            return BootstrapResourceUtils.scanManifestForVersions(f);
        }
        catch (Exception e) {
            return new Properties();
        }
    }

    public static Properties getManifestVersionsForDistribution() {
        try {
            String applicationMainJar = Bootstrap.getDistributionMainJar();
            if (applicationMainJar != null) {
                File jar = new File(applicationMainJar);
                return BootstrapResourceUtils.scanManifestForVersions(jar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Properties();
    }

    protected static Properties scanManifestForVersions(File f) {
        Properties props = new Properties();
        try (JarFile jarFile = new JarFile(f);){
            Manifest manifest = jarFile.getManifest();
            props.setProperty("org.lsst.ccs.project", manifest.getMainAttributes().getValue("CCS-Project"));
            props.setProperty("org.lsst.ccs.project.version", manifest.getMainAttributes().getValue("Implementation-Version"));
            props.setProperty("org.lsst.ccs.jenkins.build.number", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Number"));
            props.setProperty("org.lsst.ccs.jenkins.build.id", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Id"));
            props.setProperty("org.lsst.ccs.jenkins.build.url", manifest.getMainAttributes().getValue("CCS-Jenkins-Build-Url"));
            props.setProperty("org.lsst.ccs.jenkins.build.jdk", manifest.getMainAttributes().getValue("Build-Jdk"));
            props.setProperty("org.lsst.ccs.source.code.url", manifest.getMainAttributes().getValue("CCS-Source-Code-Url"));
            props.setProperty("org.lsst.ccs.source.code.revision", manifest.getMainAttributes().getValue("CCS-Source-Code-Revision"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }
}

