/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.util.ArrayList;
import org.freehep.jas.services.PlotterAdapter;

public class PlotterAdapterLookup {
    private ArrayList<AdapterEntry> adapters = new ArrayList();

    public void registerAdapter(PlotterAdapter adapter, Class from, Class to) {
        this.adapters.add(new AdapterEntry(adapter, from, to));
    }

    public PlotterAdapter adapter(Class from, Class to) {
        ArrayList<AdapterEntry> fromAdapters = new ArrayList<AdapterEntry>();
        ArrayList<AdapterEntry> toAdapters = new ArrayList<AdapterEntry>();
        for (AdapterEntry entry : this.adapters) {
            if (entry.isAdapter(from, to)) {
                return entry.adapter();
            }
            if (entry.isAdapterFrom(from)) {
                fromAdapters.add(entry);
            }
            if (!entry.isAdapterTo(to)) continue;
            toAdapters.add(entry);
        }
        if (fromAdapters.isEmpty() || toAdapters.isEmpty()) {
            return null;
        }
        for (AdapterEntry fromEntry : fromAdapters) {
            for (AdapterEntry toEntry : toAdapters) {
                if (!fromEntry.isAdapterTo(toEntry.from())) continue;
                return new CombinedAdapter(fromEntry.adapter(), toEntry.adapter());
            }
        }
        return null;
    }

    private class CombinedAdapter
    implements PlotterAdapter {
        private PlotterAdapter fromAdapter;
        private PlotterAdapter toAdapter;
        private PlotterAdapter inBetweenAdapter;

        public CombinedAdapter(PlotterAdapter fromAdapter, PlotterAdapter toAdapter) {
            this.fromAdapter = fromAdapter;
            this.toAdapter = toAdapter;
        }

        public CombinedAdapter(PlotterAdapter fromAdapter, PlotterAdapter inBetweenAdapter, PlotterAdapter toAdapter) {
            this.fromAdapter = fromAdapter;
            this.toAdapter = toAdapter;
            this.inBetweenAdapter = inBetweenAdapter;
        }

        public Object adapt(Object obj) {
            if (this.inBetweenAdapter == null) {
                return this.toAdapter.adapt(this.fromAdapter.adapt(obj));
            }
            return this.toAdapter.adapt(this.inBetweenAdapter.adapt(this.fromAdapter.adapt(obj)));
        }
    }

    private class AdapterEntry {
        private PlotterAdapter adapter;
        private Class from;
        private Class to;

        public AdapterEntry(PlotterAdapter adapter, Class from, Class to) {
            this.adapter = adapter;
            this.from = from;
            this.to = to;
        }

        public PlotterAdapter adapter() {
            return this.adapter;
        }

        public Class from() {
            return this.from;
        }

        public Class to() {
            return this.to;
        }

        public boolean isAdapter(Class from, Class to) {
            return this.isAdapterFrom(from) && this.isAdapterTo(to);
        }

        public boolean isAdapterFrom(Class from) {
            return this.from().isAssignableFrom(from);
        }

        public boolean isAdapterTo(Class to) {
            return to.isAssignableFrom(this.to());
        }
    }
}

