/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.apcpdu.ui.jas;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.command.CommandService;

public class MonitorFilter
extends AbstractChannelsFilter {
    public static final MonitorFormat FORMAT = new Formatter();
    private static final Pattern pPduOutlet = Pattern.compile("([^/]+)/states/(.+)/([^/]+)/PduOutletState");
    private final String agent;
    private final String[] pdus;

    public MonitorFilter(String agent, String pdus) {
        this.agent = agent;
        this.pdus = pdus.split(",");
    }

    public MonitorFilter(AgentInfo agent) {
        this.agent = agent.getName();
        this.pdus = agent.getAgentProperty("Pdu_Components", "").split(",");
    }

    public String getName() {
        return this.agent;
    }

    public List<String> getAgents() {
        return Collections.singletonList(this.agent);
    }

    public List<String> getOriginChannels() {
        ArrayList<String> selectors = new ArrayList<String>();
        for (String pdu : this.pdus) {
            selectors.add("/" + pdu + "/");
            selectors.add("/states/" + pdu + "/");
        }
        return selectors;
    }

    public String getOriginPath(String displayPath) {
        return super.getOriginPath(displayPath);
    }

    public String getDisplayPath(String originPath) {
        Object dp = originPath.replaceFirst(this.agent + "/states/", "");
        int i = ((String)dp).indexOf("/PduOutletState");
        if (i != -1) {
            dp = ((String)dp).substring(0, i);
            i = ((String)dp).lastIndexOf("/");
            dp = ((String)dp).substring(0, i) + "/Outlets" + ((String)dp).substring(i);
        }
        return dp;
    }

    public List<String> getFields(boolean compact) {
        if (compact) {
            return Arrays.asList(MonitorField.VALUE.getKey(), MonitorField.DESCR.getKey());
        }
        return Arrays.asList(MonitorField.VALUE.getKey(), MonitorField.UNITS.getKey(), MonitorField.LOW_ALARM.getKey(), MonitorField.LOW_WARN.getKey(), MonitorField.ALERT_LOW.getKey(), MonitorField.HIGH_WARN.getKey(), MonitorField.HIGH_ALARM.getKey(), MonitorField.ALERT_HIGH.getKey(), MonitorField.DESCR.getKey());
    }

    public static String[] getPduAndOutletName(String path) {
        Matcher m = pPduOutlet.matcher(path);
        if (m.matches()) {
            return new String[]{m.group(1) + "/" + m.group(2), m.group(3)};
        }
        return null;
    }

    private static class Formatter
    extends MonitorFormat {
        private Formatter() {
        }

        public FormattedValue format(MonitorField field, AgentChannel ch) {
            FormattedValue fv = super.format(field, ch);
            if ("ON".equals(fv.value) || "OFF".equals(fv.value)) {
                if (fv.bgColor == null) {
                    Color color = fv.bgColor = fv.value.equals("ON") ? MonitorField.COLOR_GOOD : MonitorField.COLOR_WARN;
                }
                if (fv.toolTip == null) {
                    fv.toolTip = "Click to switch ON/OFF";
                }
                fv.click1 = cell -> {
                    String[] ss;
                    AgentChannel channel;
                    List hh;
                    if (cell != null && (hh = cell.getChannels()).size() == 1 && (channel = ((DisplayChannel)hh.get(0)).getChannel()) != null && (ss = MonitorFilter.getPduAndOutletName(channel.getPath())) != null) {
                        String status = channel.get().toString();
                        boolean on = "ON".equals(status);
                        status = on ? "OFF" : "ON";
                        int flip = JOptionPane.showConfirmDialog(Console.getConsole().getWindow(), "<html>Switch the power outlet<br><b>" + ss[1] + "</b> " + status + "?", "Switch PDU outlet " + status, 2);
                        if (flip == 0) {
                            CommandService.getService().sendRaw(ss[0], on ? "outletOff" : "forceOutletOn", new Object[]{ss[1]});
                        }
                    }
                };
            }
            return fv;
        }

        public FormattedValue format(MonitorField field, List<AgentChannel> channels) {
            return channels.size() == 1 ? this.format(field, channels.get(0)) : super.format(field, channels);
        }
    }
}

