/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystem.shutter.gui.BladeSetStatusPanel;
import org.lsst.ccs.subsystem.shutter.gui.CommandPanel;
import org.lsst.ccs.subsystem.shutter.gui.Commander;
import org.lsst.ccs.subsystem.shutter.gui.Dispatcher;
import org.lsst.ccs.subsystem.shutter.gui.DisplayPanel;
import org.lsst.ccs.subsystem.shutter.gui.GeneralStatusPanel;
import org.lsst.ccs.subsystem.shutter.gui.RootPanel;
import org.lsst.ccs.subsystem.shutter.gui.StatusListener;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

@Plugin(name="LSST Shutter plugin", description="Camera shutter status and controls.")
public class ShutterPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger((String)ShutterPlugin.class.getPackage().getName());
    private final Scheduler scheduler = new Scheduler("Shutter plugin dispatcher", 1);

    public void initialize() {
        LOG.fine((Object)"Initializing plugin.");
        OptionalPage.getService().add((OptionalPage)new ShutterPage(this.getConsole(), this.scheduler));
        OptionalPage.getService().add((OptionalPage)new ChecklistPage());
    }

    public void shutdown() {
        LOG.fine((Object)"Shutting down plugin.");
        this.scheduler.shutdownNow();
    }

    public static class ShutterPage
    implements OptionalPage {
        private static final String PAGE_NAME = "Shutter GUI";
        private static final String MENU_PATH_FORMAT = "CCS Subsystems/%s/Shutter GUI";
        private final Scheduler scheduler;
        private final Console console;
        private final DisplayPanel dispPanel;
        private final BladeSetStatusPanel bladeStatusTable;
        private final GeneralStatusPanel generalStatusTable;
        private final CommandPanel commandControls;
        private final RootPanel rootPanel;
        private final JScrollPane scrollPane;
        private final Commander commander;
        private final StatusListener statusListener;
        private final Dispatcher dispat;

        public ShutterPage(Console console, Scheduler scheduler) {
            this.console = console;
            this.scheduler = scheduler;
            this.dispat = new Dispatcher();
            this.dispPanel = new DisplayPanel();
            this.bladeStatusTable = new BladeSetStatusPanel();
            this.generalStatusTable = new GeneralStatusPanel();
            this.commandControls = new CommandPanel(this.dispat);
            this.rootPanel = RootPanel.create(this.dispPanel, this.generalStatusTable, this.bladeStatusTable, this.commandControls);
            this.rootPanel.setName(PAGE_NAME);
            this.scrollPane = new JScrollPane(this.rootPanel);
            this.commander = new Commander(this);
            this.statusListener = new StatusListener(this);
            this.dispat.addReceivers(this.dispPanel, this.bladeStatusTable, this.generalStatusTable, this.commandControls, this.commander, this.statusListener);
            this.dispat.start(this.scheduler);
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            String motorType;
            String menuPath = null;
            if (agent != null && agent.getType() == AgentInfo.AgentType.WORKER && (motorType = agent.getAgentProperty("motorplatform.type")) != null && motorType.equals(AgentCategory.SHUTTER.name())) {
                menuPath = String.format(MENU_PATH_FORMAT, agent.getName());
                this.dispat.setWorkerName(agent.getName());
            }
            return menuPath;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            return this.scrollPane;
        }

        public void opened(String pageName) {
            this.getDispatcher().showWorkerIsReachable();
            this.getDispatcher().connect();
        }

        public void closed(String pageName) {
            this.getDispatcher().disconnect();
            this.getDispatcher().showWorkerIsUnreachable("");
        }

        public Console getConsole() {
            return this.console;
        }

        public Dispatcher getDispatcher() {
            return this.dispat;
        }
    }

    public static class ChecklistPage
    implements OptionalPage {
        private static final String PAGE_NAME = "Shutter checklist";
        private static final String MENU_PATH_FORMAT = "CCS Subsystems/%s/Shutter checklist";

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            String motorType;
            String menuPath = null;
            if (agent != null && agent.getType() == AgentInfo.AgentType.WORKER && (motorType = agent.getAgentProperty("motorplatform.type")).equals(AgentCategory.SHUTTER.name())) {
                menuPath = String.format(MENU_PATH_FORMAT, agent.getName());
            }
            return menuPath;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            JScrollPane checklistPane = null;
            InputStream checklistIn = null;
            try {
                checklistIn = BootstrapResourceUtils.getBootstrapResource((String)"checklist.html");
                if (checklistIn == null) {
                    byte[] msg = "<html>  <body>    <h1>getBootstrapResource() could not find <em>checklist.html</em>.</html>  </body></html>".getBytes();
                    checklistIn = new ByteArrayInputStream(msg);
                }
                JEditorPane interior = new JEditorPane();
                interior.setContentType("text/html");
                interior.setDocument(interior.getEditorKit().createDefaultDocument());
                interior.getEditorKit().read(checklistIn, interior.getDocument(), 0);
                checklistIn.close();
                interior.setEditable(false);
                checklistPane = new JScrollPane(interior);
            }
            catch (IOException | BadLocationException exc) {
                if (checklistIn != null) {
                    try {
                        checklistIn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new RuntimeException(exc);
            }
            return checklistPane;
        }
    }
}

