/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class JComboBoxWithDisabledItems<E>
extends JComboBox<E> {
    private boolean[] disabledIndices;

    public JComboBoxWithDisabledItems() {
        super.setRenderer(new Renderer());
    }

    public void setDisabled(E ... items) {
        if (items.length == 0) {
            this.disabledIndices = null;
        } else {
            List<E> itemList = Arrays.asList(items);
            int n = this.getItemCount();
            this.disabledIndices = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.disabledIndices[i] = itemList.contains(this.getItemAt(i));
            }
        }
    }

    public void setDisabled(Set<? extends E> items) {
        if (items.isEmpty()) {
            this.disabledIndices = null;
        } else {
            int n = this.getItemCount();
            this.disabledIndices = new boolean[n];
            for (int i = 0; i < n; ++i) {
                this.disabledIndices[i] = items.contains(this.getItemAt(i));
            }
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.isItemEnabled(index)) {
            super.setSelectedIndex(index);
        }
    }

    @Override
    public void removeAllItems() {
        this.disabledIndices = null;
        super.removeAllItems();
    }

    @Override
    public void removeItemAt(int anIndex) {
        this.disabledIndices = null;
        super.removeItemAt(anIndex);
    }

    @Override
    public void removeItem(Object anObject) {
        this.disabledIndices = null;
        super.removeItem(anObject);
    }

    @Override
    public void insertItemAt(E item, int index) {
        this.disabledIndices = null;
        super.insertItemAt(item, index);
    }

    @Override
    public void addItem(E item) {
        this.disabledIndices = null;
        super.addItem(item);
    }

    private boolean isItemEnabled(int index) {
        return this.disabledIndices == null || index < 0 || index >= this.disabledIndices.length || !this.disabledIndices[index];
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("ComboBox With Disabled Items Demo");
                frame.setDefaultCloseOperation(3);
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
                frame.add(panel);
                JComboBoxWithDisabledItems<String> comboBox = new JComboBoxWithDisabledItems<String>();
                comboBox.addItem("One");
                comboBox.addItem("Two");
                comboBox.addItem("Three");
                comboBox.addItem("Four");
                comboBox.setDisabled("Two", "Four");
                panel.add(comboBox);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private class Renderer
    extends BasicComboBoxRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!JComboBoxWithDisabledItems.this.isItemEnabled(index)) {
                this.setBackground(list.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

