/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.astrogrid.samp.DataException;
import org.astrogrid.samp.SampMap;

public class Subscriptions
extends SampMap {
    private static final String ATOM_REGEX = "[0-9a-zA-Z\\-_]+";
    private static String MTYPE_REGEX = "([0-9a-zA-Z\\-_]+\\.)*[0-9a-zA-Z\\-_]+";
    private static String MSUB_REGEX = "(" + MTYPE_REGEX + "|" + MTYPE_REGEX + "\\.\\*" + "|" + "\\*" + ")";
    private static final Pattern MSUB_PATTERN = Pattern.compile(MSUB_REGEX);

    public Subscriptions() {
        super(new String[0]);
    }

    public Subscriptions(Map map) {
        this();
        this.putAll(map);
    }

    public void addMType(String mtype) {
        this.put(mtype, new HashMap());
    }

    public boolean isSubscribed(String mtype) {
        if (this.containsKey(mtype)) {
            return true;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            if (Subscriptions.matchLevel((String)it.next(), mtype) < 0) continue;
            return true;
        }
        return false;
    }

    public Map getSubscription(String mtype) {
        if (this.containsKey(mtype)) {
            Object value = this.get(mtype);
            return value instanceof Map ? (Map)value : new HashMap();
        }
        int bestLevel = -1;
        Map bestValue = null;
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            int level = Subscriptions.matchLevel((String)entry.getKey(), mtype);
            if (level <= bestLevel) continue;
            bestLevel = level;
            Object value = entry.getValue();
            bestValue = value instanceof Map ? (Map)value : new HashMap();
        }
        return bestValue;
    }

    public void check() {
        super.check();
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!MSUB_PATTERN.matcher(key).matches()) {
                throw new DataException("Illegal subscription key \"" + key + "\"");
            }
            if (value instanceof Map) continue;
            throw new DataException("Subscription values are not all maps");
        }
    }

    public static Subscriptions asSubscriptions(Map map) {
        return map instanceof Subscriptions || map == null ? (Subscriptions)map : new Subscriptions(map);
    }

    public static int matchLevel(String pattern, String mtype) {
        if (mtype.equals(pattern)) {
            return Subscriptions.countAtoms(pattern);
        }
        if ("*".equals(pattern)) {
            return 0;
        }
        if (pattern.endsWith(".*")) {
            String prefix = pattern.substring(0, pattern.length() - 2);
            return mtype.startsWith(prefix) ? Subscriptions.countAtoms(prefix) : -1;
        }
        return -1;
    }

    private static int countAtoms(String text) {
        int leng = text.length();
        int natom = 1;
        for (int i = 0; i < leng; ++i) {
            if (text.charAt(i) != '.') continue;
            ++natom;
        }
        return natom;
    }
}

