/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.monitor.Channel;

public class DevicePredicate
implements Predicate<Channel> {
    private final String device;
    private static final Logger LOG = Logger.getLogger(DevicePredicate.class.getName());

    public DevicePredicate(String device) {
        this.device = device;
        LOG.log(Level.FINER, "Created Device Predicate ({0})", device);
    }

    @Override
    public boolean test(Channel channel) {
        return this.device.isEmpty() || channel.getDevice().getPath().matches(this.device);
    }

    public String toString() {
        return this.device;
    }
}

