/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import plotter.Axis;

public final class PlotLayout
implements LayoutManager2 {
    private List<Axis> axes = new ArrayList<Axis>();
    private Component dataArea;

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void addLayoutComponent(Component c, Object constraints) {
        if (c instanceof Axis) {
            this.axes.add((Axis)c);
        } else {
            this.dataArea = c;
        }
    }

    @Override
    public void addLayoutComponent(String s, Component c) {
        this.addLayoutComponent(c, s);
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void layoutContainer(Container parent) {
        int iteration;
        Rectangle bounds = parent.getBounds();
        Insets insets = new Insets(0, 0, bounds.height, bounds.width);
        for (iteration = 0; iteration < 5; ++iteration) {
            Point start;
            for (Axis axis : this.axes) {
                Point end;
                if (!axis.isVisible()) continue;
                axis.clearNudge();
                Dimension size = axis.getPreferredSize();
                if (axis.getAxisPosition() == Axis.AxisPosition.TOP) {
                    axis.setBounds(0, 0, bounds.width, size.height);
                    start = axis.getStartPoint();
                    end = axis.getEndPoint();
                    insets.top = Math.max(insets.top, start.y);
                    insets.left = Math.max(insets.left, start.x);
                    insets.right = Math.min(insets.right, end.x);
                    continue;
                }
                if (axis.getAxisPosition() == Axis.AxisPosition.BOTTOM) {
                    axis.setBounds(0, bounds.height - size.height, bounds.width, size.height);
                    start = axis.getStartPoint();
                    end = axis.getEndPoint();
                    insets.bottom = Math.min(insets.bottom, bounds.height - size.height + start.y);
                    insets.left = Math.max(insets.left, start.x);
                    insets.right = Math.min(insets.right, end.x);
                    continue;
                }
                if (axis.getAxisPosition() == Axis.AxisPosition.LEFT) {
                    axis.setBounds(0, 0, size.width, bounds.height);
                    start = axis.getStartPoint();
                    end = axis.getEndPoint();
                    insets.top = Math.max(insets.top, end.y);
                    insets.bottom = Math.min(insets.bottom, start.y);
                    insets.left = Math.max(insets.left, start.x);
                    continue;
                }
                if (axis.getAxisPosition() != Axis.AxisPosition.RIGHT) continue;
                axis.setBounds(bounds.width - size.width, 0, size.width, bounds.height);
                start = axis.getStartPoint();
                end = axis.getEndPoint();
                insets.top = Math.max(insets.top, end.y);
                insets.bottom = Math.min(insets.bottom, start.y);
                insets.right = Math.min(insets.right, bounds.width - size.width + end.x);
            }
            boolean axesAreHappy = true;
            for (Axis axis : this.axes) {
                if (!axis.isVisible()) continue;
                start = axis.getStartPoint();
                if (axis.getAxisPosition() == Axis.AxisPosition.TOP) {
                    axis.setLocation(0, insets.top - start.y);
                    axis.nudgeStartAndEndPoint(insets.left, bounds.width - insets.right);
                } else if (axis.getAxisPosition() == Axis.AxisPosition.BOTTOM) {
                    axis.setLocation(0, insets.bottom - start.y);
                    axis.nudgeStartAndEndPoint(insets.left, bounds.width - insets.right);
                } else if (axis.getAxisPosition() == Axis.AxisPosition.LEFT) {
                    axis.setLocation(insets.left - start.x, 0);
                    axis.nudgeStartAndEndPoint(bounds.height - insets.bottom, insets.top);
                } else if (axis.getAxisPosition() == Axis.AxisPosition.RIGHT) {
                    axis.setLocation(insets.right - start.x, 0);
                    axis.nudgeStartAndEndPoint(bounds.height - insets.bottom, insets.top);
                }
                axesAreHappy &= axis.isHappy();
            }
            if (axesAreHappy) break;
        }
        System.out.println("PloyLayout took " + iteration + " iterations");
        if (this.dataArea != null) {
            this.dataArea.setBounds(insets.left, insets.top, insets.right - insets.left, insets.bottom - insets.top);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension preferredSize = new Dimension();
        for (Axis axis : this.axes) {
            if (!axis.isVisible()) continue;
            Dimension size = axis.getPreferredSize();
            if (axis.getAxisPosition().isVertical()) {
                preferredSize.width += size.width;
                continue;
            }
            preferredSize.height += size.height;
        }
        if (this.dataArea != null) {
            Dimension size = this.dataArea.getPreferredSize();
            preferredSize.width += size.width;
            preferredSize.height += size.height;
        }
        return preferredSize;
    }

    @Override
    public void removeLayoutComponent(Component c) {
        if (c instanceof Axis) {
            this.axes.remove((Axis)c);
        } else if (c == this.dataArea) {
            this.dataArea = null;
        }
    }
}

