/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import plotter.AxisModel;

public abstract class AbstractAxisModel
implements AxisModel {
    private EventListenerList listeners = new EventListenerList();
    private ChangeListener cl;

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    protected void fireAxisChanged() {
        int n = this.listeners.getListenerCount(ChangeListener.class);
        if (n > 0) {
            for (ChangeListener listener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
                listener.stateChanged(null);
            }
        }
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    protected void addDelegate(AxisModel source) {
        if (this.cl == null) {
            this.cl = new DelegateChangeListener();
        }
        source.addChangeListener(this.cl);
    }

    protected void removeDelegate(AxisModel source) {
        source.removeChangeListener(this.cl);
    }

    private class DelegateChangeListener
    implements ChangeListener {
        private DelegateChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractAxisModel.this.fireAxisChanged();
        }
    }
}

