/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui.gantry;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelEvent;
import org.lsst.ccs.gconsole.base.panel.PanelListener;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyCaller;
import org.lsst.ccs.subsystem.motorplatform.bus.gantry.GantryReplyCaller;
import org.lsst.ccs.subsystem.motorplatform.gui.gantry.GantryControls;
import org.lsst.ccs.utilities.logging.Logger;

@Plugin(name="GantryControlPanel", description="For operating the integration gantry.")
public class GantryPlugin
extends ConsolePlugin
implements StatusMessageListener,
CommandOriginator,
PanelListener {
    private static final Logger LOG = Logger.getLogger((String)GantryPlugin.class.getPackage().getName());
    private volatile PanelManager pm;
    private volatile GantryControls gui;
    private volatile JScrollPane pane;
    private volatile ExecutorService commandExec;
    private volatile Action toggleGUIAction;
    private final BlockingQueue<Object> commandQueue = new ArrayBlockingQueue<Object>(1000);
    private static final String TARGET = "gantry-motorplatform";

    public void initialize() {
        this.pm = this.getConsole().getPanelManager();
        this.toggleGUIAction = new AbstractAction("Gantry"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GantryPlugin.this.toggleGUI();
            }
        };
        this.toggleGUIAction.putValue("SwingSelectedKey", false);
        this.getServices().addMenu(this.toggleGUIAction, new String[]{"CCS Subsystems"});
    }

    private void toggleGUI() {
        if (this.gui == null) {
            this.openGUI();
        } else {
            this.closeGUI();
        }
    }

    private void openGUI() {
        this.gui = new GantryControls(this.commandQueue);
        this.pane = new JScrollPane(this.gui);
        this.pm.open((Component)this.pane, "Gantry Control Panel");
        this.startStatusListening();
        this.startCommandTask();
        this.pm.addListener((PanelListener)this);
    }

    private void closeGUI() {
        this.toggleGUIAction.putValue("SwingSelectedKey", false);
        this.pm.removeListener((PanelListener)this);
        this.stopCommandTask();
        this.stopStatusListening();
        this.pm.close((Component)this.pane);
        this.pane = null;
        this.gui = null;
    }

    public void start() {
    }

    public void stop() {
    }

    public void process(PanelEvent e) {
        if (e.hasKey((Object)Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue()) {
            SwingUtilities.invokeLater(() -> this.closeGUI());
        }
    }

    public void onStatusMessage(StatusMessage s) {
        StatusSubsystemData ssd = (StatusSubsystemData)s;
        KeyValueData kvd = ssd.getSubsystemData();
        SwingUtilities.invokeLater(() -> this.passStatusToGUI(kvd.getValue()));
    }

    private void passStatusToGUI(Serializable msg) {
        if (msg instanceof MotorReplyCaller) {
            ((MotorReplyCaller)((Object)msg)).callMotorReplyHandler(this.gui);
        } else if (msg instanceof GantryReplyCaller) {
            ((GantryReplyCaller)((Object)msg)).callGantryReplyHandler(this.gui);
        }
    }

    private void startStatusListening() {
        this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        this.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, this.makeFilter());
    }

    void stopStatusListening() {
        this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
    }

    private Predicate<BusMessage<? extends Serializable, ?>> makeFilter() {
        Predicate target = BusMessageFilterFactory.messageOrigin((String)TARGET);
        Predicate standard = BusMessageFilterFactory.messageClass(StatusSubsystemData.class);
        return target.and(standard);
    }

    public void processAck(CommandAck ack) {
        LOG.fine((Object)"Command ACK.");
    }

    public void processResult(CommandResult result) {
        Object embedded = result.getResult();
        LOG.log(Level.FINE, "Command returned result {0}.", embedded == null ? null : embedded.getClass().getSimpleName());
    }

    public void processNack(CommandNack nack) {
        LOG.fine((Object)"Command NACK.");
    }

    private void startCommandTask() {
        this.commandQueue.clear();
        this.commandExec = Executors.newSingleThreadExecutor();
        this.commandExec.submit(this::commandLoop);
    }

    private void stopCommandTask() {
        this.commandExec.shutdownNow();
    }

    private void commandLoop() {
        AgentMessagingLayer messaging = this.getConsole().getMessagingAccess();
        boolean go = true;
        while (go) {
            try {
                Object cmd = this.commandQueue.take();
                messaging.sendCommandRequest(this.makeCommandRequest(cmd), (CommandOriginator)this);
            }
            catch (InterruptedException ex) {
                go = false;
            }
            catch (Exception ex) {
                LOG.warning((Object)"Exception in Gantry plugin command loop.", (Throwable)ex);
            }
        }
        ArrayList leftovers = new ArrayList();
        this.commandQueue.drainTo(leftovers);
        for (Object cmd : leftovers) {
            messaging.sendCommandRequest(this.makeCommandRequest(cmd), (CommandOriginator)this);
        }
    }

    private CommandRequest makeCommandRequest(Object cmd) {
        String cmdClassName = cmd.getClass().getSimpleName();
        String cmdName = cmdClassName.substring(0, 1).toLowerCase() + cmdClassName.substring(1);
        LOG.log(Level.INFO, "Command name is {0}", (Object)cmdName);
        return new CommandRequest(TARGET, cmdName, new Object[]{cmd});
    }
}

