/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class VerticalLine
extends JComponent {
    private int length = 60;
    int startingX = 10;
    int startingY = 0;

    public VerticalLine() {
        super.setPreferredSize(new Dimension(2 * this.startingX, this.length));
    }

    public VerticalLine(int length) {
        this.length = length;
        super.setPreferredSize(new Dimension(2 * this.startingX, length));
    }

    public VerticalLine(int height, int startingY) {
        this.length = height;
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(2 * this.startingX, height));
    }

    public void setLength(int size) {
        this.length = size;
        super.setPreferredSize(new Dimension(2 * this.startingX, this.length));
        this.repaint();
    }

    public void setStartingY(int startingY) {
        this.startingY = startingY;
        super.setPreferredSize(new Dimension(2 * this.startingX, this.length));
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        Path2D.Double linePath = new Path2D.Double();
        ((Path2D)linePath).moveTo(this.startingX, this.startingY);
        ((Path2D)linePath).lineTo(this.startingX, this.length);
        g2d.setColor(Color.BLACK);
        g2d.draw(linePath);
        g2d.dispose();
    }

    public static void main(String[] argv) {
        VerticalLine d = new VerticalLine();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

