/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import javax.swing.event.ChangeListener;
import plotter.ContinuousAxisModel;

class ScaledAxisModel
implements ContinuousAxisModel {
    private final ContinuousAxisModel sourceModel;
    private final double offset;
    private final double scale;

    public ScaledAxisModel(ContinuousAxisModel sourceModel, double offset, double scale) {
        this.sourceModel = sourceModel;
        this.offset = offset;
        this.scale = scale;
    }

    @Override
    public double getModelCoordinateFromAxisCoordinate(double axisCoordinate) {
        return this.offset + this.scale * this.sourceModel.getModelCoordinateFromAxisCoordinate(axisCoordinate);
    }

    @Override
    public double getAxisCoordinateFromModelCoordinate(double modelCoordinate) {
        return this.sourceModel.getModelCoordinateFromAxisCoordinate(modelCoordinate) / this.scale - this.offset;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.sourceModel.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.sourceModel.removeChangeListener(l);
    }
}

